/*
 * This file is part of the KDE project
 *
 * Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <stdlib.h>
#include <vector>

#include <tqpoint.h>
#include <tqrect.h>
#include <tqthread.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <kinstance.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kdebug.h>
#include <kgenericfactory.h>

#include <kis_doc.h>
#include <kis_image.h>
#include <kis_iterators_pixel.h>
#include <kis_layer.h>
#include <kis_filter_registry.h>
#include <kis_global.h>
#include <kis_types.h>

// #include <tdemessagebox.h>

#include "threadtest.h"

typedef KGenericFactory<ChalkThreadTest> ChalkThreadTestFactory;
K_EXPORT_COMPONENT_FACTORY( chalkthreadtest, ChalkThreadTestFactory( "chalk" ) )

ChalkThreadTest::ChalkThreadTest(TQObject *parent, const char *name, const TQStringList &)
        : KParts::Plugin(parent, name)
{
    setInstance(ChalkThreadTestFactory::instance());

    if (parent->inherits("KisFilterRegistry")) {
        KisFilterRegistry * r = dynamic_cast<KisFilterRegistry *>(parent);
        r->add(new KisFilterInvert());
    }
}

ChalkThreadTest::~ChalkThreadTest()
{
}

class InversionThread : public TQThread
{

public:

    InversionThread(const TQString & name, KisPaintDeviceSP src, KisPaintDeviceSP dst, const TQRect& rect)
        : TQThread()
        , m_name(name)
        , m_src(src)
        , m_dst(dst)
        , m_rect(rect)
        {
            kdDebug() << "Thread created " << m_name << ", " << TQThread::currentThread() << ", " << m_rect << "\n";
        };

    void run()
        {
            kdDebug() << "Thread started:" << m_name  << ", " << TQThread::currentThread() << "\n";

            KisRectIteratorPixel dstIt = m_dst->createRectIterator(m_rect.x(), m_rect.y(), m_rect.width(), m_rect.height(), true );
            KisRectIteratorPixel srcIt = m_src->createRectIterator(m_rect.x(), m_rect.y(), m_rect.width(), m_rect.height(), false);
            TQ_INT32 depth = m_src -> colorSpace() -> nColorChannels();

            kdDebug() << "Thread " << m_name << " starts loop \n";

            while( ! srcIt.isDone() ) {
                if ( srcIt.isSelected() ) {
                    for( int i = 0; i < depth; i++) {
                        dstIt.rawData()[i] = TQ_UINT8_MAX - srcIt.oldRawData()[i];
                   }
                }
                ++srcIt;
                ++dstIt;
            }
            kdDebug() << "Thread " << m_name << " finished \n";
        };

private:
    TQString m_name;
    KisPaintDeviceSP m_src;
    KisPaintDeviceSP m_dst;
    TQRect m_rect;

};

KisFilterInvert::KisFilterInvert() : KisFilter(id(), "colors", i18n("Invert with &Threads"))
{
}

void KisFilterInvert::process(KisPaintDeviceSP src, KisPaintDeviceSP dst, KisFilterConfiguration* /*config*/, const TQRect& rect)
{
    kdDebug() << "Going to invert " << rect << "\n";
    int h2 = rect.height() / 2;
    int w2 = rect.width() / 2;

    setProgressTotalSteps(4);
    InversionThread t1("t1", src, dst, TQRect(0, 0, w2, h2));
    InversionThread t2("t2", src, dst, TQRect(w2, 0, w2, h2));
    InversionThread t3("t3", src, dst, TQRect(0, h2, w2, h2));
    InversionThread t4("t4", src, dst, TQRect(w2, h2, w2, h2));

    t1.start();
    t2.start();
    t3.start();
    t4.start();
    t1.wait();
    setProgress(1);
    t2.wait();
    setProgress(2);
    t3.wait();
    setProgress(3);
    t4.wait();
    setProgress(4);

    setProgressDone();
}
