/***************************************************************************
                          thinbuttons.cpp  -  description
                             -------------------
    begin                : Tue Nov 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "thinbuttons.moc"
#include <kicontheme.h>
#include <tqpushbutton.h>
#include <tqstyle.h>

thinbuttons::thinbuttons(TQWidget *parent, const char *name, resource *Rsrc ) : TQFrame(parent,name)
{
	Resource = Rsrc;
	rightClickID = 0;
	setFixedSize( 8, 8 );

	/* Build the pop-up menu */
	matchMenu = new TDEPopupMenu( this );
	matchMenu->insertItem( TQIconSet( Resource->LoadIcon( TQString("document-save"), TDEIcon::Small ) ),
													i18n("&Save Match"), MENU_SAVE );
	matchMenu->insertItem( TQIconSet( Resource->LoadIcon( TQString("document-save"), TDEIcon::Small ) ),
													i18n("Save Match &As..."), MENU_SAVEAS );
	matchMenu->insertSeparator();
	matchMenu->insertItem( TQIconSet( Resource->LoadIcon( TQString("document-print"), TDEIcon::Small ) ),
													i18n("&Print Notation..."), MENU_PRINT );
	matchMenu->insertSeparator();
	matchMenu->insertItem( TQIconSet( Resource->LoadIcon( TQString("window-close"), TDEIcon::Small ) ),
													i18n("&Close Match"), MENU_CLOSE );
	connect( matchMenu, TQT_SIGNAL( activated(int) ), this, TQT_SLOT( menuClicked(int) ) );
}
thinbuttons::~thinbuttons()
{
}
///////////////////////////////////////
//
//	thinbuttons::childEvent
//
///////////////////////////////////////
void thinbuttons::childEvent( TQChildEvent * cev )
{
	/* Make sure this method only effects child buttons */
	if( TQString( TQT_TQOBJECT(cev->child())->name() ) != TQString( "MatchSelector" ) )
		return;
	if( cev->removed() )
		remove( (TQButton*)cev->child() );
}
///////////////////////////////////////
//
//	thinbuttons::create
//
///////////////////////////////////////
TQButton* thinbuttons::create( int id )
{
	Buttons *newBut;
	TQPushButton *newButton;

	newButton = new TQPushButton( this, "MatchSelector" );

	newBut = new Buttons;
	newBut->button = newButton;
	newBut->ID = id;
	buttons.append( newBut );

	newButton->setToggleButton( TRUE );
	newButton->setText( TQString("Match") );
	newButton->show();

	connect( newButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( buttonClicked() ) );
	return newButton;
}
///////////////////////////////////////
//
//	thinbuttons::setButton
//
///////////////////////////////////////
void thinbuttons::setButton( int id )
{
	Buttons *currentBut;
	unsigned int Index;

	for( Index = 0; Index < buttons.count(); Index++ )
	{
		currentBut = buttons.at( Index );
		if( currentBut->ID == id )
		{
			currentBut->button->setDown( TRUE );
			if( currentBut->button->isToggleButton() )
				if( currentBut->button->state() != TQButton::On )
					currentBut->button->toggle();
		}
		else
		{
			currentBut->button->setDown( FALSE );
			if( currentBut->button->isToggleButton() )
				if( currentBut->button->state() == TQButton::On )
					currentBut->button->toggle();
		}
	}	
}
///////////////////////////////////////
//
//	thinbuttons::find
//
///////////////////////////////////////
TQButton* thinbuttons::find( int id )
{
	unsigned int tmp;

	for( tmp = 0; tmp < buttons.count(); tmp++ )
		if( buttons.at( tmp )->ID == id )
			return buttons.at( tmp )->button;
	return NULL;
}
///////////////////////////////////////
//
//	thinbuttons::id
//
///////////////////////////////////////
int thinbuttons::id( TQButton* button )
{
	unsigned int tmp;

	for( tmp = 0; tmp < buttons.count(); tmp++ )
		if( buttons.at( tmp )->button == button )
			return buttons.at( tmp )->ID;
	return -1;
}
///////////////////////////////////////
//
//	thinbuttons::remove
//
///////////////////////////////////////
void thinbuttons::remove( TQButton* button )
{
	unsigned int tmp;

	for( tmp = 0; tmp < buttons.count(); tmp++ )
		if( buttons.at( tmp )->button == button )
		{
			disconnect( buttons.at( tmp )->button, TQT_SIGNAL( clicked() ), this, TQT_SLOT( buttonClicked() ) );
			buttons.remove( tmp );
		}
}
void thinbuttons::remove( const int &id )
{
	TQButton *butt;

	butt = find(id);
	if( butt != NULL )
	{
		remove( butt );
		delete butt;
	}
}
///////////////////////////////////////
//
//	thinbuttons::buttonClicked
//
///////////////////////////////////////
void thinbuttons::buttonClicked( void )
{
	const TQObject *incomming;
	int Clicked;
	unsigned int tmp;

	incomming = TQT_TQOBJECT(const_cast<TQT_BASE_OBJECT_NAME*>(sender()));
	for( tmp = 0; tmp < buttons.count(); tmp++ )
		if( buttons.at( tmp )->button == ( const TQButton* )incomming )
		{
			Clicked = buttons.at( tmp )->ID;
			if( Clicked == Null ) return;
			setButton( Clicked );
			emit leftClick( Clicked );
		}
}
///////////////////////////////////////
//
//	thinbuttons::resize
//
///////////////////////////////////////
void thinbuttons::resize( const int Width )
{
	Buttons *button;
	TQStyle& Style = TQApplication::style();
	int margin;
	unsigned int Index;

	margin = Style.defaultFrameWidth();
	if( buttons.count() != 0 ) buttWidth = ( Width / buttons.count() ) - ( margin * 2 );
	else buttWidth = 0;
	setFixedSize( Width, Resource->Widget_Height + margin );
	for( Index = 0; Index < buttons.count(); Index++ )
	{
		button = buttons.at( Index );
		button->button->setFixedSize( buttWidth, Resource->Widget_Height );
		button->button->move( ( Index * ( buttWidth + ( margin * 2 ) ) ) + margin , margin );
	}
}
///////////////////////////////////////
//
//	thinbuttons::mousePressEvent
//
///////////////////////////////////////
void thinbuttons::mousePressEvent( TQMouseEvent *event )
{
	TQStyle& Style = TQApplication::style();
	int margin, xpos(0), index(0);

	/* We only want RightClick */
	if(event->button() != Qt::RightButton)
	{
		return;
	}
	event->accept();
	margin = Style.defaultFrameWidth();
	/* No Buttons, No Menu */
	if( !buttons.count() )
	{
		return;
	}
	/* Figure out which button was pressed */
	xpos += margin;
	while( xpos < event->x() )
	{
		if( ( event->x() >= xpos ) && ( event->x() <= ( xpos + buttWidth ) ) )
		{
			break;
		}
		xpos += ( margin << 1 ) + buttWidth;
		index++;
	}
	/* Clicked the right margin */
	if( xpos >= event->x() )
	{
		return;
	}
	/* Clicked a button, let's dance */
	matchMenu->popup( event->globalPos() );
	rightClickID =  buttons.at(index)->ID;
	emit rightClick( rightClickID );
}
///////////////////////////////////////
//
//	thinbuttons::menuClicked
//
///////////////////////////////////////
void thinbuttons::menuClicked( int item )
{
	emit menuItemSelected( rightClickID, item );
}
