/***************************************************************************
                          proto_xboard.h  -  description
                             -------------------
    begin                : Sat Oct 26 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROTO_XBOARD_H
#define PROTO_XBOARD_H

#include "proto_base.h"

/**
  *@author Troy Corbin Jr.
  */

class TQTimer;

class proto_xboard : public proto_base
{
	Q_OBJECT
  
	public:
											proto_xboard( const int ID );
											~proto_xboard();

		virtual void			parse( const Command& );
		virtual void			parse( const TQString& );

	protected slots:
		void							releaseBuffer( void );

	private:

		/* XBoard protover 2 */
		bool							FEATURE_Analyze;
		bool							FEATURE_Colors;
		bool							FEATURE_Draw;
		bool							FEATURE_ICS;
		bool							FEATURE_Name;
		bool							FEATURE_Pause;
		bool							FEATURE_Ping;
		bool							FEATURE_PlayOther;
		bool							FEATURE_Reuse;
		bool							FEATURE_SetBoard;
		bool							FEATURE_SAN;
		bool							FEATURE_SIGINT;
		bool							FEATURE_SIGTERM;
		bool							FEATURE_Time;
		bool							FEATURE_UserMove;
		int								FEATURE_Variants;
		TQString						FEATURE_MyName;
		/* XBoard protover 3 */
		int								FEATURE_Level;
		int								FEATURE_BookEngine;

		bool							Check;
		bool							Turn;
		bool							Team;
		bool							Army;
		bool							JustMoved;
		bool							AcceptIllegal;
		bool							DelayedGo;
		bool							Forced;
		TQTimer						*InitTimer;
		CommandList				*CMDList;
};

#endif
