/***************************************************************************
 *
 * knetworkmanager-connection_setting_8021x.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_8021X_H
#define KNETWORKMANAGER_CONNECTION_SETTING_8021X_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include <tqdbusdata.h>

#include "knetworkmanager-connection_setting.h"
#include "qbidirectionalmap.h"
/* NM */
#include <nm-setting-8021x.h>
#include <nm-setting-wireless.h>


class AccessPoint;

namespace ConnectionSettings
{

// setting for 802.1x parameters
class IEEE8021x : public ConnectionSetting
{
	public:

		enum EAP
		{
		  EAP_NONE = 0
		, EAP_LEAP
		, EAP_MD5
		, EAP_PAP
		, EAP_CHAP
		, EAP_MSCHAP
		, EAP_MSCHAPV2
		, EAP_FAST
		, EAP_PSK
		, EAP_PAX
		, EAP_SAKE
		, EAP_GPSK
		, EAP_TLS
		, EAP_PEAP
		, EAP_TTLS
		, EAP_SIM
		, EAP_GTC
		, EAP_OTP
		};

		enum EAP_PHASE1
		{
		  EAP_PHASE1_NONE = EAP_NONE
		, EAP_PHASE1_LEAP = EAP_LEAP
		, EAP_PHASE1_MD5 = EAP_MD5
		, EAP_PHASE1_TLS = EAP_TLS
		, EAP_PHASE1_PEAP = EAP_PEAP
		, EAP_PHASE1_TTLS = EAP_TTLS
		, EAP_PHASE1_SIM = EAP_SIM
		, EAP_PHASE1_FAST = EAP_FAST
		};

		enum EAP_PHASE2
		{
		  EAP_PHASE2_AUTH_NONE = EAP_NONE
		, EAP_PHASE2_AUTH_PAP = EAP_PAP
		, EAP_PHASE2_AUTH_CHAP = EAP_CHAP
		, EAP_PHASE2_AUTH_MSCHAP = EAP_MSCHAP
		, EAP_PHASE2_AUTH_MSCHAPV2 = EAP_MSCHAPV2
		, EAP_PHASE2_AUTH_GTC = EAP_GTC
		, EAP_PHASE2_AUTH_OTP = EAP_OTP
		, EAP_PHASE2_AUTH_MD5 = EAP_MD5
		, EAP_PHASE2_AUTH_TLS = EAP_TLS
		};

		enum EAP_PHASE2_AUTH_EAP
		{
		  EAP_PHASE2_AUTH_EAP_NONE = EAP_NONE
		, EAP_PHASE2_AUTH_EAP_MD5 = EAP_MD5
		, EAP_PHASE2_AUTH_EAP_MSCHAPV2 = EAP_MSCHAPV2
		, EAP_PHASE2_AUTH_EAP_OTP = EAP_OTP
		, EAP_PHASE2_AUTH_EAP_GTC = EAP_GTC
		, EAP_PHASE2_AUTH_EAP_TLS = EAP_TLS
		};

		enum PEAPVER
		{
			PEAPVER_0 = 0
		, PEAPVER_1
		};

		IEEE8021x(Connection* conn);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		SettingsMap toSecretsMap(bool with_settings = true) const;
		bool        fromSecretsMap(const SettingsMap&);

		// FIXME
		// multiple EAP methods are allowed
		EAP_PHASE1 getEAP(void) const;
		void     setEAP(EAP_PHASE1);

		EAP_PHASE2 getPhase2EAP(void) const;
		void       setPhase2EAP(EAP_PHASE2);

		TQString  getIdentity(void) const;
		void     setIdentity(const TQString&);

		TQString  getAnonIdentity(void) const;
		void     setAnonIdentity(const TQString&);

		TQString  getPassword(void) const;
		void     setPassword(const TQString&);

		// FIXME
		// ca cert

		TQString  getCaPath(void) const;
		void     setCaPath(TQString);

		bool     getUseSystemCaCert(void) const;
		void     setUseSystemCaCert(bool);

		//FIXME
		// client cert

		// FIXME
		// private key

		PEAPVER  getPhase1PeapVer(void) const;
		void     setPhase1PeapVer(PEAPVER);

		// get a list of allowed phase2 methods
		TQValueList<EAP_PHASE2> getAllowedPhase2Methods() const;

		bool     isValid() const;

	private:
		// settigs
		EAP_PHASE1          _eap;
		EAP_PHASE2          _eapPhase2;

		TQString             _identity;
		TQString             _anonIdentity;
		TQByteArray          _caCert;
		bool                _useSystemCaCert;
		TQString             _caPath;
		TQByteArray          _clientCert;
		TQByteArray          _privateKey;
		TQString             _phase1PeapVer;
		TQString             _phase1PeapLabel;
		TQString             _phase1FastProvisioning;
		TQString             _phase2AuthEAP;
		TQByteArray          _phase2CaCert;
		TQString             _phase2CaPath;
		TQByteArray          _phase2ClientCert;
		TQByteArray          _phase2PrivateKey;

		// secrets
		TQString             _password;
		TQString             _privateKeyPasswd;
		TQString             _phase2PrivateKeyPasswd;

		// map the different eap types (enum EAP) to their string representation
		TQBiDirectionalMap<EAP, TQString> _eapMap;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_8021X_H */
