/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/
#ifndef KMFKMFPROTOCOLLIBRARY_H
#define KMFKMFPROTOCOLLIBRARY_H

#include <tqobject.h>
#include <tqvaluelist.h>
#include <tqstring.h>
#include <tquuid.h>
#include <kurl.h>

namespace KMF {
class KMFError;
class KMFProtocol;
class KMFProtocolCategory;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
class KMFProtocolLibrary : public TQObject {
Q_OBJECT
  
/** Static Stuff **/
public:
	static KMFProtocolLibrary* instance();
	
private:
	static KMFProtocolLibrary* m_instance;
	
/** End Static stuff **/
public:
    ~KMFProtocolLibrary();


public: 
	// TQPtrList<KMFProtocol>* protocolLibrary();
	KMFError* saveProtocolLibrary();
	void forceProtocolLibraryReload();
	void loadProtocolDefinitionsFromURL( const KURL&, KMFError* err );
	TQValueList<KMFProtocolCategory*>& protocolCategories();
	TQValueList<KMFProtocol*>& allProtocols();
	
	KMFProtocolCategory* findCategory( const TQUuid& uuid );
 	KMFProtocol* findProtocolByName( const TQString& name );
	KMFProtocol* findProtocolByUuid( const TQUuid& uuid );
	KMFProtocol* findEquivalentProtocol( KMFProtocol* compare );

private: 
	TQValueList< KMFProtocolCategory* > m_protocolCategories;
	TQValueList< KMFProtocol* > m_protocols;


private: 
 	KMFProtocolLibrary( TQObject* parent, const char* name );
	KMFProtocolLibrary();

	bool m_libraryLoaded;

};

}

#endif
