/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/

#ifndef __KMFINSTALLER_INTERFACE_H
#define __KMFINSTALLER_INTERFACE_H

#include <kdemacros.h>

#include <tqvaluelist.h>

class TQString;
class TQStringList;
class KURL;

namespace KMF {
class KMFDoc;
class KMFIPTDoc;
class KMFTarget;
class KMFCompilerInterface;


class KDE_EXPORT KMFInstallerInterface {
	public:
		KMFInstallerInterface();
		virtual ~KMFInstallerInterface();
		virtual KMFCompilerInterface* compiler() = 0;
		virtual void cmdRunFW() = 0;
		virtual void cmdStopFW() = 0;
		virtual void cmdShowRunningConfig( const TQString& ) = 0;
		virtual void cmdInstallFW() = 0;
		virtual void cmdUninstallFW() = 0;
		virtual void generateInstallerPackage( KMFTarget *, const KURL& ) = 0;
		virtual const TQString& osName() const = 0;
		virtual const TQString& osGUIName() const = 0;
		virtual TQValueList<KMFCompilerInterface*>* compilers() = 0;
		
	};
}

#endif // __KMFINSTALLER_INTERFACE_Hs
