/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXENTRYWIDGET_H
#define KBIBTEXENTRYWIDGET_H

#include <tqwidget.h>
#include <tqdialog.h>
#include <tqvaluelist.h>
#include <tqmap.h>

#include <kdialogbase.h>

#include "entry.h"
#include "entrywidgetsource.h"
#include "webquery.h"

class TQComboBox;
class TQLineEdit;
class TQCheckBox;
class TQTabWidget;
class TQString;
class TQTimer;
class TQListView;

class TDEConfig;

namespace KBibTeX
{
    class EntryWidgetTab;
    class WebQueryArXiv;

    class EntryWidget : public TQWidget
    {
        Q_OBJECT

        friend class EntryWidgetDialog;

    public:
        ~EntryWidget();

        static TQDialog::DialogCode execute( BibTeX::Entry *entry, BibTeX::File *bibtexfile, bool isReadOnly, bool isNew, TQWidget *parent = 0, const char *name = 0 );

    protected:
        EntryWidget( BibTeX::File *bibtexfile, bool isReadOnly, bool isNew, TQDialog *parent, const char *name = 0 );
        void showEvent( TQShowEvent * );
        bool queryClose();

    private slots:
        void apply();
        void reset();
        void apply( BibTeX::Entry *entry );
        void reset( BibTeX::Entry *entry );
        void slotEnableAllFields();
        void slotForceDefaultIdSuggestion();
        void slotEntryTypeChanged();
        void slotCurrentPageChanged( TQWidget* newPage );
        void warningsExecute( TQListViewItem* item );
        void updateWarnings();
        void insertIdSuggestion( int id );
        void updateIdSuggestionsMenu();
        void refreshFromURL();
        void useExternalEntry( BibTeX::Entry*, bool );
        void endExternalSearch( WebQuery::Status );

    signals:
        void updateTabs( BibTeX::Entry::EntryType entryType, bool enableAll, bool isReadOnly );

    private:
        EntryWidget( BibTeX::Entry *entry, BibTeX::File *bibtexfile, bool isReadOnly, bool isNew, TQDialog *parent, const char *name = 0 );
        BibTeX::Entry *m_originalEntry;
        BibTeX::File *m_bibtexfile;
        bool m_isReadOnly;
        bool m_isNew;
        bool m_defaultIdSuggestionAvailable;

        TQComboBox *m_comboBoxEntryType;
        TQLineEdit *m_lineEditID;
        TQPushButton *m_pushButtonForceDefaultIdSuggestion;
        TQPushButton *m_pushButtonIdSuggestions;
        TQPopupMenu *m_menuIdSuggestions;
        TQMap<int, TQString> m_idToSuggestion;
        TQCheckBox *m_checkBoxEnableAll;
        TQPushButton *m_pushButtonRefetch;
        TQListView *m_listViewWarnings;
        TQTabWidget *m_tabWidget;
        KBibTeX::EntryWidgetSource *m_sourcePage;
        TQValueList<KBibTeX::EntryWidgetTab*> m_internalEntryWidgets;
        TQWidget *m_lastPage;
        TQTimer *m_updateWarningsTimer;
        TQDialog *m_dlgParent;
        WebQueryArXiv *m_wqa;
        TQString m_oldId;

        void setupGUI( TQWidget *parent, bool showWarnings = TRUE );
        void addTabWidgets();
        void addTabWidget( EntryWidgetTab *widget, const TQString& title );
        void setupEntryTypes();
        void updateGUI();
        void internalApply( BibTeX::Entry *entry );
        void internalReset( BibTeX::Entry *entry );
        void restoreWindowSize( TDEConfig *config );
        void saveWindowSize( TDEConfig *config ) const;
    };

    class EntryWidgetDialog: public KDialogBase
    {
        Q_OBJECT
    public:
        EntryWidgetDialog( TQWidget *parent = 0, const char *name = 0, bool modal = true, const TQString &caption = TQString::null, int buttonMask = Ok | Apply | Cancel ) : KDialogBase( parent, name, modal, caption, buttonMask ) {/* nothing */};
        ~EntryWidgetDialog() {/* nothing */};
        void setMainWidget( EntryWidget *widget )
        {
            KDialogBase::setMainWidget( widget );
            m_widget = widget;
        };

    protected:
        void closeEvent( TQCloseEvent * e )
        {
            if ( m_widget->queryClose() ) e->accept();
            else e->ignore();
        }

    protected slots:
        void slotCancel()
        {
            if ( m_widget->queryClose() ) TQDialog::done( Cancel );
        }

        void slotClose()
        {
            if ( m_widget->queryClose() ) TQDialog::done( Cancel );
        }

    private:
        EntryWidget *m_widget;
    };

}

#endif
