//
// C++ Interface: k9haldevice
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9HALDEVICE_H
#define K9HALDEVICE_H
#include "k9common.h"

#ifdef Q_MOC_RUN
#define HAVE_HAL
#endif // Q_MOC_RUN

#ifdef HAVE_HAL

#include <tqobject.h>
/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9HalConnection;
class k9HalDevice : public TQObject
{
Q_OBJECT
  
public:   
    
    k9HalDevice(TQObject *parent = 0, const char *name = 0);

    ~k9HalDevice();

	bool getCanReadCd() const {
	    return m_canReadCd;
	}

	bool getCanReadDvd() const {
	    return m_canReadDvd;
	}

	bool getCanBurnCd() const {
	    return m_canBurnCd;
	}

	bool getCanBurnDvd() const {
	    return m_canBurnDvd;
	}

	TQString getModel() const {
	    return m_model;
	}

	int getMaxWriteSpeed() const {
	    return m_maxWriteSpeed;
	}

	TQString getDeviceName() const {
	    return m_deviceName;
	}
	void updateVolumeName();

	TQString getVolumeUdi() const {
	    return m_volumeUdi;
	}

	TQString getVolumeName() const {
	    return m_volumeName;
	}
	
	TQString mountPoint();
signals:
   void volumeChanged(const TQString &device,const TQString &volumeName);	
	
private:
    TQString m_volumeName;
    TQString m_volumeUdi;
    k9HalConnection *m_connection;
    bool m_canReadCd,m_canReadDvd,m_canBurnCd,m_canBurnDvd;
    TQString m_model;
    TQString m_deviceName;
    int m_maxWriteSpeed;
    void getDriveProperties();
    TQString volumeName();
};

#endif
#endif
