//
// C++ Interface: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9CHAPTEREDIT_H
#define K9CHAPTEREDIT_H

#include "k9common.h"
#include "../k9author/chapterEdit.h"
#include "k9avidecode.h"
#include "k9avifile.h"

class k9DrawImage;
class k9ChapterEdit : public chapterEdit
{
  Q_OBJECT
  

public:
  k9ChapterEdit(TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~k9ChapterEdit();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
private:
  k9AviDecode m_aviDecode;
  k9DrawImage *m_wimage;
  k9AviFile *m_aviFile;
  TQTime m_minTime,m_maxTime;
  bool m_noUpdate;
  TQImage m_image;
protected:
  /*$PROTECTED_FUNCTIONS$*/
  virtual void sliderReleased();
  virtual void sliderChanged();
  virtual void bStartClick();
  virtual void bEndClick();
  virtual void ckBreakStartClick();
  virtual void ckBreakEndClick();
  virtual void urlSelected(const TQString&);
  virtual void startChanged(const TQTime&);
  virtual void endChanged(const TQTime&);
  virtual void bTitleButtonClick();
protected slots:
  /*$PROTECTED_SLOTS$*/
  void drawImage(TQImage *);
public slots:
  void setAviFile(k9AviFile *_aviFile);
};

#endif

