// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/
#ifndef JPEGCONTENT_H
#define JPEGCONTENT_H

// TQt
#include <tqcstring.h>

// Local
#include <imageutils/orientation.h>

#include "../gvcore/libgwenview_export.h"

class TQImage;
class TQString;
class TQFile;

namespace ImageUtils {


class LIBGWENVIEW_EXPORT JPEGContent {
public:
	JPEGContent();
	~JPEGContent();
	
	Orientation orientation() const;
	void resetOrientation();
  
	int dotsPerMeterX() const;
	int dotsPerMeterY() const;

	TQSize size() const;

	TQString comment() const;
	void setComment(const TQString&);

	TQString aperture() const;
	TQString exposureTime() const;
	TQString iso() const;
	TQString focalLength() const;

	TQString getExifInformation(const TQString exifkey) const;

	void transform(Orientation);

	TQImage thumbnail() const;
	void setThumbnail(const TQImage&);

	bool load(const TQString& file);
	bool loadFromData(const TQByteArray& rawData);
	bool save(const TQString& file);
	bool save(TQFile*);

private:
	struct Private;
	Private *d;

	JPEGContent(const JPEGContent&);
	void operator=(const JPEGContent&);
    void applyPendingTransformation();
	int dotsPerMeter(const TQString& keyName) const;
};


} // namespace


#endif /* JPEGCONTENT_H */
