// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2006 Aurélien Gâteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
// Self
#include "inputdialog.moc"

// TQt
#include <tqlabel.h>
#include <tqvbox.h>

// KDE
#include <klineedit.h>

namespace Gwenview {

struct InputDialog::Private {
	KLineEdit* mLineEdit;
	TQLabel* mLabel;
};

	
InputDialog::InputDialog(TQWidget* parent)
: KDialogBase(parent, "InputDialog", true, TQString(),
	KDialogBase::Ok|KDialogBase::Cancel)
{
	d = new Private;
	TQVBox* page = makeVBoxMainWidget();
	d->mLabel = new TQLabel(page);

	d->mLineEdit = new KLineEdit(page);
	d->mLineEdit->setFocus();
	
	setMinimumWidth(350);

	connect(d->mLineEdit, TQT_SIGNAL(textChanged(const TQString&)),
		this, TQT_SLOT(updateButtons()) );
}


InputDialog::~InputDialog() {
	delete d;
}


void InputDialog::setLabel(const TQString& label) {
	d->mLabel->setText(label);
}


KLineEdit* InputDialog::lineEdit() const {
	return d->mLineEdit;
}


void InputDialog::updateButtons() {
	enableButtonOK( ! d->mLineEdit->text().isEmpty() );
}


} // namespace

