// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#ifndef FILETHUMBNAILVIEWITEM_H
#define FILETHUMBNAILVIEWITEM_H

// TQt 
#include <tqiconview.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqvaluevector.h>

class KFileItem;

namespace Gwenview {
/**
 * We override the TQIconViewItem to control the look of selected items
 * and get a pointer to our KFileItem
 */
class FileThumbnailViewItem : public TQIconViewItem {
public:
	class Line;
	class CroppedLine;
	class WrappedLine;
	enum { PADDING=4 };

	FileThumbnailViewItem(TQIconView* parent,const TQString& text,const TQPixmap& icon, KFileItem* fileItem);
	~FileThumbnailViewItem();

	KFileItem* fileItem() const { return mFileItem; }

	void setImageSize(const TQSize&);
	
	void updateLines();

protected:
	void paintItem(TQPainter* painter, const TQColorGroup& colorGroup);
	void calcRect( const TQString& text_=TQString() );
	void paintFocus(TQPainter*, const TQColorGroup&) {}
	bool acceptDrop(const TQMimeSource*) const;
	void dropped(TQDropEvent*, const TQValueList<TQIconDragItem>&);

	KFileItem* mFileItem;
	TQValueVector<Line*> mLines;

	TQSize mImageSize;
};

} // namespace
#endif

