//
// C++ Interface: mediadevicemanager
//
// Description: Controls device/medium object handling, providing
//              helper functions for other objects
//
//
// Author: Jeff Mitchell <kde-dev@emailgoeshere.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef AMAROK_MEDIA_DEVICE_MANAGER_H
#define AMAROK_MEDIA_DEVICE_MANAGER_H

#include "medium.h"

#include <tqmap.h>

#include <dcopobject.h>

typedef TQMap<TQString, Medium*> MediumMap;

class MediaDeviceManager : public TQObject
{

    //static const uint GENERIC = 0;
    //static const uint APPLE = 1;
    //static const uint IFP = 2;

    Q_OBJECT
  
    public:
        MediaDeviceManager();
        ~MediaDeviceManager();
        static MediaDeviceManager *instance();

        Medium* getDevice( TQString name );
        MediumMap getMediumMap() { return m_mediumMap; }

        void addManualDevice( Medium* added );
        void removeManualDevice( Medium* removed );


    signals:
        void mediumAdded( const Medium*, TQString );
        void mediumChanged( const Medium*, TQString );
        void mediumRemoved( const Medium*, TQString );

    public slots:
        void slotMediumAdded( const Medium*, TQString );
        void slotMediumChanged( const Medium*, TQString );
        void slotMediumRemoved( const Medium*, TQString );

    private slots:
        void reinitDevices();

    private:

        MediumMap m_mediumMap;

};

#endif

