/** -*- C++ -*-
    @file adept/utils.cpp
    @author Peter Rockai <me@mornfall.net>
*/

#include <map>
#include <unistd.h>
#include <adept/utils.h>

namespace adept {

TQMutex Threads::serialize;
Threads::Queue Threads::threads;

void Threads::wait() {
    static std::map< TQMutex *, int > locked;
    while ( !threads.empty() ) {
        TQThread *current = threads.front().first;
        if ( current->finished() ) {
            delete current;
            threads.pop_front();
            continue;
        }
        for ( Queue::iterator thr = threads.begin(); thr != threads.end(); ++thr ) {
            ++locked[ thr->second ];
            thr->second->lock();
        }
        kapp->processEvents();
        for ( Queue::iterator thr = threads.begin(); thr != threads.end(); ++thr ) {
            while ( locked[ thr->second ] > 0 ) {
                thr->second->unlock();
                --locked[ thr->second ];
            }
        }
        usleep( 50000 );
    }
}

void Threads::enqueue( TQThread *t, TQMutex *m )
{
    threads.push_back( std::make_pair( t, m ) );
    t->start();
}

}
