/*
	Copyright (C) 2005 by Tobias Erbsland <te@profzone.ch>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	version 2, License as published by the Free Software Foundation.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.  If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/
#ifndef TQTBUILDCONFIG_H
#define TQTBUILDCONFIG_H

#include <tqobject.h>
#include <tqstringlist.h>

class CppSupportPart;
class TQDomDocument;

/**
	@brief The QtBuildConfig class stores all parameters related to the used TQt library

	@author Tobias Erbsland <te@profzone.ch>
*/
class QtBuildConfig : public TQObject
{
	Q_OBJECT
  

public:
	QtBuildConfig( CppSupportPart* part, TQDomDocument* dom );
	virtual ~QtBuildConfig();

	inline bool isUsed() const { return m_used; }
	inline int version() const { return m_version; }
	inline int includeStyle() const { return m_includeStyle; }
	inline const TQString& root() const { return m_root; }
    inline const TQString& qmakePath() const { return m_qmakePath; }
    inline const TQString& designerPath() const { return m_designerPath; }
    inline const TQStringList& designerPluginPaths() const { return m_designerPluginPaths; }
	inline const TQString& designerIntegration() const { return m_designerIntegration; }

	void setUsed( bool used );
	void setVersion( int version );
	void setIncludeStyle( int style );
	void setRoot( const TQString& root );
    void setDesignerPath( const TQString& path );
    void setDesignerPluginPaths( const TQStringList& pfx );
    void setTQMakePath( const TQString& path );
	void setDesignerIntegration( const TQString& designerIntegration );
	void init();

public slots:
	void store();

signals:
	void stored();

private:

    bool isValidTQtDir( const TQString& ) const;
    void findTQtDir();
    TQString findExecutable( const TQString& ) const;
    void buildBinDirs( TQStringList& ) const;
    bool isExecutable( const TQString& ) const;

	CppSupportPart* m_part; ///< The cpp support part
	TQDomDocument* m_dom; ///< The project configuration

	bool m_used; ///< Flag if qt is used in this project.
	int m_version; ///< The major version of the qt library (3 or 4)
	int m_includeStyle; ///< The type of include style used (qt 3 or 4)
	TQString m_root; ///< The root directory of the used qt installation for TQt3
    TQString m_designerPath; ///< The path including the binary name of TQt Designer
    TQString m_qmakePath; ///< The path including the binary name of TQMake
    TQStringList m_designerPluginPaths; ///< The Prefix for Designer
	TQString m_designerIntegration; ///< The type of designer used, kdevdesigner or qt designer

	static const TQString m_configRoot; ///< The root path of the configuration
};

#endif

// kate: indent-mode csands; tab-width 4; space-indent off;
