###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for Doxygen

if( BUILD_DOC AND BUILD_KIG )
  find_program( DOXYGEN_BINARY NAMES doxygen )
  if( NOT DOXYGEN_BINARY )
     tde_message_fatal( "Doxygen is required to build Kig scripting api documentation, but was not found on your system" )
  endif( )
endif( )


##### check for arts

if( WITH_ARTS )
   pkg_search_module( ARTS arts )
   if( NOT ARTS_FOUND )
      tde_message_fatal( "aRts is requested but was not found on your system" )
   endif( NOT ARTS_FOUND )
   set( WITHOUT_ARTS false )
endif( WITH_ARTS )

if( NOT WITH_ARTS )
   set( WITHOUT_ARTS 1 )
endif( NOT WITH_ARTS )


##### check for boost

if( BUILD_KBRUCH )

find_package( Boost )

if( NOT Boost_FOUND )
    tde_message_fatal( "Boost is required, but was not found on your system" )
endif()
endif( BUILD_KBRUCH )


##### check for Python

if( BUILD_KIG )

if( ${CMAKE_VERSION} VERSION_LESS "3.12" )
    find_package( PythonInterp )
    find_package( PythonLibs )
    if( NOT PYTHONLIBS_FOUND )
        tde_message_fatal( "Python is required, but was not found on your system" )
    endif( NOT PYTHONLIBS_FOUND )
 else( )
    find_package( Python COMPONENTS Interpreter Development )
    if( NOT Python_Development_FOUND )
        tde_message_fatal( "Python is required, but was not found on your system" )
    endif( )
    set( PYTHON_VERSION_STRING "${Python_VERSION}" )
    set( PYTHON_VERSION_MAJOR  "${Python_VERSION_MAJOR}" )
    set( PYTHON_VERSION_MINOR  "${Python_VERSION_MINOR}" )
    set( PYTHON_INCLUDE_DIRS   "${Python_INCLUDE_DIRS}" )
    set( PYTHON_LIBRARIES      "${Python_LIBRARIES}" )
  endif( )

  if( "${PYTHON_VERSION_STRING}" VERSION_LESS "3.0" )
    set( KIG_Python_init "initkig"
         CACHE STRING "KIG: Init function for python-boost" )
  else( )
    set( KIG_Python_init "PyInit_kig"
         CACHE STRING "KIG: Init function for python-boost" )
  endif( )
endif( BUILD_KIG )


# Check for Python Boost

if( BUILD_KIG AND WITH_KIG_PYTHON_SCRIPTING )

find_package( Boost COMPONENTS python${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR} )

if( NOT Boost_FOUND )
    find_package( Boost COMPONENTS python )
endif( )

if( NOT Boost_FOUND )
     tde_message_fatal( "Boost Python Library is required, but was not found on your system" )
   else()
     set( KIG_ENABLE_PYTHON_SCRIPTING 1 )
endif( NOT Boost_FOUND )

if( NOT Boost_PYTHON_LIBRARY AND Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY )
    set( Boost_PYTHON_LIBRARY "${Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY}" )
endif( )
endif( BUILD_KIG AND WITH_KIG_PYTHON_SCRIPTING )


##### check for headers

check_include_file( stdint.h HAVE_STDINT_H )


##### check for TIMEZONE_IS_INT

check_cxx_source_compiles("
#include <time.h>
int main()
{
    daylight = 0;
    timezone = 0;
    return 0;
}"
TIMEZONE_IS_INT)

