class Viewer < TQt::Widget
	slots 'setDefault()', 'setSansSerif()', 'setItalics()'

	def initialize
		super

		setFontSubstitutions

		codec = TQt::TextCodec::codecForName("utf8")
		
		# Shouldn't 'pack("U*")' for UTF-8 work here? - Richard
		# The 'U' option packs each element into two bytes and doesn't work
		# The 'c' option packs them into a single byte and does work
		greeting_heb = codec.toUnicode([0327, 0251, 0327, 0234, 0327, 0225, 0327, 0235].pack("C*"))
		greeting_ru = codec.toUnicode([0320, 0227, 0320, 0264, 0321, 0200, 0320, 0260, 0320, 0262, 0321, 0201, 0321, 0202, 0320, 0262, 0321, 0203, 0320, 0271, 0321, 0202, 0320, 0265].pack("C*"))
		greeting_en = 'Hello'

		@greetings = TQt::TextView.new(self, 'textview')
		@greetings.setText(
				   greeting_en + "\n" +
				   greeting_ru + "\n" +
				   greeting_heb)

		@fontInfo = TQt::TextView.new(self, 'fontinfo')

		setDefault

		@defaultButton = TQt::PushButton.new('Default', self, 'pushbutton1')
		@defaultButton.setFont(TQt::Font.new('times'))
		connect(@defaultButton, SIGNAL('clicked()'), self, SLOT('setDefault()'))


		@sansSerifButton = TQt::PushButton.new('Sans Serif', self, 'pushbutton2')
		@sansSerifButton.setFont(TQt::Font.new('Helvetica', 12))
		connect(@sansSerifButton, SIGNAL('clicked()'), self, SLOT('setSansSerif()'))

		@italicsButton = TQt::PushButton.new('Italics', self, 'pushbutton1')
		@italicsButton.setFont(TQt::Font.new('lucida', 12, TQt::Font.Bold, true))
		connect(@italicsButton, SIGNAL('clicked()'), self, SLOT('setItalics()'))

		layout
	end

	def setDefault
		font = TQt::Font.new('Bavaria')
		font.setPointSize(24)
		font.setWeight(TQt::Font.Bold)
		font.setUnderline(true)

		@greetings.setFont(font)
		showFontInfo(font)
	end

	def setSansSerif
		font = TQt::Font.new('Newyork', 18)
		font.setStyleHint(TQt::Font.SansSerif)

		@greetings.setFont(font)
		showFontInfo(font)
	end

	def setItalics
		font = TQt::Font.new('Tokyo')
		font.setPointSize(32)
		font.setWeight(TQt::Font.Bold)
		font.setItalic(true)

		@greetings.setFont(font)
		showFontInfo(font)
	end

	def setFontSubstitutions
		substitutes = Array.new

		substitutes.push('Times')
		substitutes.push('Mincho')
		substitutes.push('Arabic Newspaper')
		substitutes.push('crox')

		TQt::Font.insertSubstitutions('Bavaria', substitutes)
		TQt::Font.insertSubstitution('Tokyo', 'Lucida')
	end

	def layout
		textViewContainer = TQt::HBoxLayout.new
		textViewContainer.addWidget(@greetings)
		textViewContainer.addWidget(@fontInfo)

		buttonContainer = TQt::HBoxLayout.new
		buttonContainer.addWidget(@defaultButton)
		buttonContainer.addWidget(@sansSerifButton)
		buttonContainer.addWidget(@italicsButton)

		maxButtonHeight = @defaultButton.height

		if (@sansSerifButton.height > maxButtonHeight)
			maxButtonHeight = @sansSerifButton.height
		end

		if (@italicsButton.height > maxButtonHeight)
			maxButtonHeight = @italicsButton.height
		end

		@defaultButton.setFixedHeight(maxButtonHeight)
		@sansSerifButton.setFixedHeight(maxButtonHeight)
		@italicsButton.setFixedHeight(maxButtonHeight)

		container = TQt::VBoxLayout.new(self)
		container.addLayout(textViewContainer)
		container.addLayout(buttonContainer)

		resize(700, 250)
	end

	def showFontInfo (font)
		info = TQt::FontInfo.new(font)
		messageText =
			'Font requested: "' +
			font.family + '" ' +
			font.pointSize.to_s + 'pt<BR>' +
			'Font used: "' +
			info.family.to_s + '" ' +
			info.pointSize.to_s + 'pt<P>'

		substitutions = TQt::Font.substitutes(font.family)

		unless substitutions.size == 0
			messageText = messageText + 'The following substitutions exist for ' +
				font.family + ':<UL>'
			substitutions.each {|x|
				messageText = messageText + '<LI>"' + x + '"'
			}
			messageText = messageText + '</UL>'
		else
			messageText = messageText + 'No substitutions exist for ' + font.family + '.'
		end

		@fontInfo.setText(messageText)
	end
end
