/***************************************************************************
                          textedit.cpp - Rich text viewing widget with links
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* KDE INCLUDES */
#include <tdelocale.h>

/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqstring.h>

/* OTHER INCLUDES */
#include "kommanderplugin.h"
#include <specials.h>
#include "textbrowser.h"

enum Functions {
  FirstFunction = 420,
  TBR_setNotifyClick,
  TBR_isNotifyClick,
  LastFunction
};

TextBrowser::TextBrowser(TQWidget * a_parent, const char *a_name)
  : KTextBrowser(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(TBR_setNotifyClick, "setNotifyClick(TQString widget, bool Set)",i18n("Set notify click to intercept clicks and handle links"), 2, 2);
  KommanderPlugin::registerFunction(TBR_isNotifyClick, "isNotifyClick(TQString widget)",i18n("Set notify click to intercept clicks and handle links"), 1);
}

TQString TextBrowser::currentState() const
{
  return TQString("default");
}

TextBrowser::~TextBrowser()
{
}

bool TextBrowser::isKommanderWidget() const
{
  return true;
}

TQStringList TextBrowser::associatedText() const
{
  return KommanderWidget::associatedText();
}

void TextBrowser::setAssociatedText(const TQStringList & a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void TextBrowser::setPopulationText(const TQString & a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString TextBrowser::populationText() const
{
  return KommanderWidget::populationText();
}

void TextBrowser::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
  setWidgetText(txt);
}

void TextBrowser::setWidgetText(const TQString & a_text)
{
  setText(a_text);
}

void TextBrowser::showEvent(TQShowEvent * e)
{
  TQTextBrowser::showEvent(e);
  emit widgetOpened();
}

void TextBrowser::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}


bool TextBrowser::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::selection || f == DCOP::clear || (f >= FirstFunction && f <= LastFunction);
}

TQString TextBrowser::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setText(args[0]);
      break;
    case DCOP::selection:
      return selectedText();
    case TBR_setNotifyClick:
      KTextBrowser::setNotifyClick(args[0]);
      break;
    case TBR_isNotifyClick:
      return TQString::number(KTextBrowser::isNotifyClick());
      break;
    case DCOP::clear:
      clear();
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "textbrowser.moc"
