/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *   Extended to use perforce 2002 by Harald Fernengel <harry@kdevelop.org>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PERFORCEPART_H_
#define _PERFORCEPART_H_

#include <kdevversioncontrol.h>
#include <tdelocale.h>

class Context;
class TQPopupMenu;
class TDEAction;

class PerforcePart : public KDevVersionControl
{
    Q_OBJECT
  

public:
    PerforcePart( TQObject *parent, const char *name, const TQStringList & );
    ~PerforcePart();

    virtual TQString shortDescription() const
    { return i18n( "Perforce is a version control system" ); }

    virtual void createNewProject(const TQString& /* dir */) {}
    virtual bool fetchFromRepository() { return true; }
    virtual KDevVCSFileInfoProvider *fileInfoProvider() const { return 0; }
    virtual bool isValidDirectory(const TQString& /* dirPath*/) const
    { return true; }

private slots:
    void contextMenu(TQPopupMenu *popup, const Context *context);
    void slotCommit();
    void slotUpdate();
    void slotAdd();
    void slotRemove();
    void slotEdit();
    void slotRevert();
    void slotDiff();

    void slotActionCommit();
    void slotActionUpdate();
    void slotActionAdd();
    void slotActionRemove();
    void slotActionEdit();
    void slotActionRevert();
    void slotActionDiff();

    void slotDiffFinished( const TQString&, const TQString& );

private:
    void commit( const TQString& filename );
    void update( const TQString& filename );
    void add( const TQString& filename );
    void remove( const TQString& filename );
    void edit( const TQString& filename );
    void revert( const TQString& filename );
    void diff( const TQString& filename );
    TQString currentFile();

    /** calls p4 with the command cmd and appends the filename */
    void execCommand( const TQString& cmd, const TQString& filename );
    void setupActions();
    TQString popupfile;
    TDEAction *actionEdit, *actionRevert,
            *actionSubmit, *actionSync,
            *actionDiff, *actionAdd, *actionRemove;
};

#endif
