/***************************************************************************
                          propsview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqobjectdict.h>
#include <tqobjectlist.h>
#include <tqmetaobject.h>
#include <tqstrlist.h>
#include <tqvariant.h>
#include <tqcursor.h>

#include <tdelocale.h>

#include "propsview.h"

class KSpyItem : TDEListViewItem 
{
public:
  KSpyItem( TQListView * parent, TQString label1, TQString label2 = TQString(), TQString label3 = TQString(), TQString label4 = TQString(), TQString label5 = TQString(), TQString label6 = TQString() )  
    : TDEListViewItem(parent, label1, label2, label3, label4, label5, label6)
  {
  }
protected:
  void paintCell( TQPainter * p, const TQColorGroup & cg,
                            int column, int width, int alignment )
  {
    if (column == 1 && text(2) == "TQColor") {
      TQColorGroup color_cg( cg.foreground(), cg.background(), 
                            cg.light(), cg.dark(), cg.mid(), 
                            TQColor(text(1)), TQColor(text(1)) );
      TQListViewItem::paintCell(p, color_cg, column, width, alignment);
    } else {
      TDEListViewItem::paintCell(p, cg, column, width, alignment);
    }
  }
};

PropsView::PropsView(TQWidget *parent, const char *name ) : TDEListView(parent,name)
{
  addColumn( i18n( "Name" ) );
  addColumn( i18n( "Value" ) );
  addColumn( i18n( "Type" ) );
  addColumn( i18n( "Access" ) );
  addColumn( i18n( "Designable" ) );
  addColumn( i18n( "Type Flags" ) );

  setAllColumnsShowFocus( true );
  setColumnAlignment( 3, AlignCenter );
  setColumnAlignment( 4, AlignCenter );
  setFullWidth( true );
}

PropsView::~PropsView()
{
}

void PropsView::buildList( TQObject *o )
{
  TQMetaObject *mo = o->metaObject();
  TQStrList names = mo->propertyNames( true );

  for ( uint i = 0; i < names.count(); i++ ) {
    char *prop = names.at( i );
    TQVariant v = o->property( prop );
    const TQMetaProperty *mp = mo->property( mo->findProperty(prop, true), true );

    TQString val( "????" );
    switch( v.type() ) {
       case TQVariant::String:
       case TQVariant::CString:
         val = v.toString();
         break;
       case TQVariant::Bool:
         val = ( v.toBool() ? "True" : "False" );
         break;
       case TQVariant::Color:
       {
         TQColor c = v.toColor();
         val = c.name();
         break;
       }
       case TQVariant::Cursor:
       {
         TQCursor c = v.toCursor();
         val = TQString("shape=%1").arg(c.shape());
         break;
       }
       case TQVariant::Font:
       {
         TQFont f = v.toFont();
         val = TQString("family=%1, pointSize=%2, weight=%3, italic=%4, bold=%5, underline=%6, strikeOut=%7")
                       .arg(f.family())
                       .arg(f.pointSize())
                       .arg(f.weight())
                       .arg(f.italic())
                       .arg(f.bold())
                       .arg(f.underline())
                       .arg(f.strikeOut());
         break;
       }
       case TQVariant::Int:
         val.setNum( v.toInt() );
         if (mp->isEnumType()) {
#ifdef USE_QT4
//            TQMetaObject * metaObject = *(mp->meta);										// FIXME
           val = TQString("%1::%2").arg("QT4_CANNOT_FIND_TQMETAOBJECT_FOR_TQMETAPROPERTY").arg(mp->valueToKey(val.toInt()));	// FIXME
#else // USE_QT4
           TQMetaObject * metaObject = *(mp->meta);
           val = TQString("%1::%2").arg(metaObject->className()).arg(mp->valueToKey(val.toInt()));
#endif // USE_QT4
         }
         break;
       case TQVariant::Point:
       {
         TQPoint p = v.toPoint();
         val = TQString("x=%1, y=%2").arg(p.x()).arg(p.y());
         break;
       }
       case TQVariant::Rect:
       {
         TQRect r = v.toRect();
         val = TQString("left=%1, right=%2, top=%3, bottom=%4")
                       .arg(r.left())
                       .arg(r.right())
                       .arg(r.top())
                       .arg(r.bottom());
         break;
       }
       case TQVariant::Size:
       {
         TQSize s = v.toSize();
         val = TQString("width=%1, height=%2").arg(s.width()).arg(s.height());
         break;
       }
       case TQVariant::SizePolicy:
       {
         TQSizePolicy s = v.toSizePolicy();
         val = TQString("horData=%1, verData=%2").arg(s.horData()).arg(s.verData());
         break;
       }
       case TQVariant::Double:
         val.setNum( v.toDouble() );
         break;
       default:
         break;
    }

    TQString ro("R/O");
    TQString rw("R/W");
    TQString st("Set");
    TQString et("Enum");
    TQString yes("Yes");
    TQString no("No");

    TQString writable = ( mp->writable() ? rw : ro );
    TQString setType = ( mp->isSetType() ? st : TQString() );
    TQString enumType = ( mp->isEnumType() ? et : TQString() );
    TQString designable = ( mp->designable(o) ? yes : no );

    TQString flags;
    bool first = true;
    if ( !setType.isNull() ) {
      if ( first )
        first = false;
      else
        flags += " | ";

      flags += setType;
    }
    if ( !enumType.isNull() ) {
      if ( first )
        first = false;
      else
        flags += " | ";

      flags += enumType;
    }

    new KSpyItem( this, prop, val, v.typeName(), writable, designable, flags );
  }
}

void PropsView::setTarget( TQObject *o )
{
  clear();
  buildList( o );
}
#include "propsview.moc"
