/* dataprovider.h
   Copyright (C) 2004 Klarlvdalens Datakonsult AB

   This file is part of TQGPGME.
 
   TQGPGME is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   TQGPGME is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with TQGPGME; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.  */

// -*- c++ -*-
#ifndef __TQGPGME_DATAPROVIDER_H__
#define __TQGPGME_DATAPROVIDER_H__

#include <gpgmepp/interfaces/dataprovider.h>

#include <tqcstring.h>
#include <tdepimmacros.h>

namespace QGpgME {

  class KDE_EXPORT TQByteArrayDataProvider : public GpgME::DataProvider {
  public:
    TQByteArrayDataProvider();
    TQByteArrayDataProvider( const TQByteArray & initialData );
    ~TQByteArrayDataProvider();

    const TQByteArray & data() const { return mArray; }

  private:
    // these shall only be accessed through the dataprovider
    // interface, where they're public:
    /*! \reimp */
    bool isSupported( Operation ) const { return true; }
    /*! \reimp */
    ssize_t read( void * buffer, size_t bufSize );
    /*! \reimp */
    ssize_t write( const void * buffer, size_t bufSize );
    /*! \reimp */
    off_t seek( off_t offset, int whence );
    /*! \reimp */
    void release();

  private:
    TQByteArray mArray;
    off_t mOff;
  };

} // namespace QGpgME

#endif // __TQGPGME_EVENTLOOPINTERACTOR_H__


