/*
    This file is part of Kandy.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqfile.h>

#include <tdeapplication.h>
#include <dcopclient.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdemessagebox.h>

#include "modem.h"
#include "kandy.h"
#include "mobilemain.h"
#include "mobilegui.h"
#include "commandscheduler.h"
#include "kandyprefs.h"

static const char description[] =
    I18N_NOOP("Communicating with your mobile phone.");

static const char version[] = "0.5.1";

static TDECmdLineOptions options[] =
{
   { "terminal", I18N_NOOP("Show terminal window"), 0 },
   { "mobilegui", I18N_NOOP("Show mobile GUI"), 0 },
   { "nogui", I18N_NOOP("Do not show GUI"), 0 },
   { "+[profile]", I18N_NOOP("Filename of command profile file"), 0 },
   TDECmdLineLastOption // End of options.
};

void initModem(Modem *modem)
{
  kdDebug() << "Opening serial Device: "
            << KandyPrefs::serialDevice()
            << endl;

  modem->setSpeed( KandyPrefs::baudRate().toUInt() );
  modem->setData(8);
  modem->setParity('N');
  modem->setStop(1);

#if 0
  if (!modem->dsrOn()) {
    KMessageBox::sorry(this, i18n("Modem is off."), i18n("Modem Error"));
    modem->close();
    return;
  }
  if (!modem->ctsOn()) {
    KMessageBox::sorry(this, i18n("Modem is busy."), i18n("Modem Error"));
    modem->close();
    return;
  }
#endif

#if 0
  modem->writeLine("");
  usleep(250000);
  modem->flush();
  modem->writeLine("ATZ");
#endif
}

int main(int argc, char **argv)
{
  TDEAboutData about("kandy", I18N_NOOP("Kandy"), version, description,
                   TDEAboutData::License_GPL, "(C) 2001 Cornelius Schumacher",0,
                   "http://kandy.kde.org/");
  about.addAuthor( "Cornelius Schumacher", 0, "schumacher@kde.org" );
  about.addAuthor( "Heiko Falk", 0, "hf2@ls12.cs.uni-dortmund.de" );
  TDECmdLineArgs::init(argc,argv,&about);
  TDECmdLineArgs::addCmdLineOptions(options);

  TDEApplication app;
  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(),false);

  Modem *modem = new Modem(KandyPrefs::self());
  CommandScheduler *scheduler = new CommandScheduler(modem);

  // see if we are starting with session management
  if (app.isRestored()) {
    // TODO: do session management
//      RESTORE(Kandy)
  } else
  {
    // no session.. just start up normally
    Kandy *k = new Kandy(scheduler);

    MobileMain *m = new MobileMain(scheduler, KandyPrefs::self());
    
    if (!args->isSet("gui")) {
    } else {
      if (KandyPrefs::startupTerminalWin() ||
          args->isSet("terminal")) {
        k->show();
      }
      if (KandyPrefs::startupMobileWin() ||
          args->isSet("mobilegui")) {
        m->show();
      }
    }

    if (args->count() == 1) {
      k->load(TQFile::decodeName(args->arg(0)));
    } else if (args->count() > 1) {
      args->usage();
    }

    args->clear();

    TQObject::connect(k,TQT_SIGNAL(showMobileWin()),m,TQT_SLOT(show()));
    TQObject::connect(m,TQT_SIGNAL(showTerminalWin()),k,TQT_SLOT(show()));
    TQObject::connect(m,TQT_SIGNAL(showPreferencesWin()),
                     k,TQT_SLOT(optionsPreferences()));

    TQObject::connect( m->view(), TQT_SIGNAL( connectModem() ), k,
                      TQT_SLOT( modemConnect() ) );
    TQObject::connect( m->view(), TQT_SIGNAL( disconnectModem() ), k,
                      TQT_SLOT( modemDisconnect() ) );

    TQObject::connect( modem, TQT_SIGNAL( errorMessage( const TQString & ) ),
                      k, TQT_SLOT( showErrorMessage( const TQString & ) ) );

    initModem( modem );

    if ( KandyPrefs::startupModem() )
      m->view()->toggleConnection();
  }

  return app.exec();
}
