#ifndef __MENUMAKER_H__
#define __MENUMAKER_H__

#include <tdeaction.h>
#include <tqobject.h>
#include <string>
#include <list>

class MenuMaker;

class MenuEntry : public TQObject
{
	Q_OBJECT
  

protected:
	MenuMaker *menumaker;
	TDEAction *action;
	TQCString text;

public:
	MenuEntry(MenuMaker *menumaker, TDEActionMenu *parent, const char *text);

public slots:
	void activated();
};

class MenuCategory
{
protected:
	TDEActionMenu *_menu;
	TQString _name;
	std::list<std::string> prefixList;
	bool _catchall;

public:
	MenuCategory(const TQString& name, const char *prefix, TDEActionMenu *menu);

	void addPrefix(const char *prefix);
	TQString name();
	TDEActionMenu *menu();

	bool catchall();
	bool matches(const char *item);
};

class MenuMaker :public TQObject
{
	Q_OBJECT
  

	std::list<MenuCategory *> categories;
public:
	enum { CAT_MAGIC_ID = 10000 };

	MenuMaker(TDEActionMenu *root);

	void addCategory(const TQString& name, const char *prefix);
	MenuCategory *lookupCategoryByName(const TQString& name);
	void addItem(const char *name, int i);
	TQString basename(const TQString& name);
	TQString catname(const TQString& name);

	void clear();

	const char *findID(int id);

	void menuActivated(const char *text);
signals:
	void activated(const char *text);
};
#endif
