
  

#ifndef KJSEMBED_QCanvasSprite_H
#define KJSEMBED_QCanvasSprite_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasSprite;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasSprite methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class TQCanvasSpriteImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasSprite_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_setSequence_2,
       Method_move_4,
       Method_move_5,
       Method_setFrame_6,
       Method_setFrameAnimation_7,
       Method_frame_8,
       Method_frameCount_9,
       Method_rtti_10,
       Method_collidesWith_11,
       Method_boundingRect_12,
       Method_width_13,
       Method_height_14,
       Method_leftEdge_15,
       Method_topEdge_16,
       Method_rightEdge_17,
       Method_bottomEdge_18,
       Method_leftEdge_19,
       Method_topEdge_20,
       Method_rightEdge_21,
       Method_bottomEdge_22,
       Method_image_23,
       Method_imageAdvanced_24,
       Method_image_25,
       Method_advance_26,
       Method_draw_27,
       Method_Last = -1
   };

   TQCanvasSpriteImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~TQCanvasSpriteImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasSprite *toTQCanvasSprite( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object TQCanvasSprite_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value setSequence_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value move_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value move_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrame_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrameAnimation_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frame_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frameCount_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collidesWith_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value boundingRect_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value width_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value height_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value leftEdge_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value topEdge_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rightEdge_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value bottomEdge_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value leftEdge_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value topEdge_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rightEdge_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value bottomEdge_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value image_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value imageAdvanced_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value image_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value advance_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value draw_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasSprite *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasSprite_H

// Local Variables:
// c-basic-offset: 4
// End:


