
  

#ifndef KJSEMBED_QCanvasSpline_H
#define KJSEMBED_QCanvasSpline_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasSpline;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasSpline methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class TQCanvasSplineImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasSpline_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_setControlPoints_3,
       Method_controlPoints_4,
       Method_closed_5,
       Method_rtti_6,
       Method_Last = -1
   };

   TQCanvasSplineImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~TQCanvasSplineImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasSpline *toTQCanvasSpline( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object TQCanvasSpline_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value setControlPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value controlPoints_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value closed_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasSpline *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasSpline_H

// Local Variables:
// c-basic-offset: 4
// End:


