/* ============================================================
 * File  : setupcamera.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-02-10
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqapplication.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistview.h>
#include <tqpushbutton.h>
#include <tqframe.h>

// KDE includes.

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <khelpmenu.h>
#include <kiconloader.h>
#include <tdepopupmenu.h>
#include <kstandarddirs.h>

// Include files for KIPI

#include <libkipi/version.h>

// Local includes.

#include "pluginsversion.h"
#include "kpaboutdata.h"
#include "setupcamera.h"
#include "cameraselection.h"
#include "cameralist.h"
#include "cameratype.h"
#include "gpiface.h"

namespace KIPIKameraKlientPlugin
{

SetupCamera::SetupCamera(TQWidget* parent, const char* name) 
           : KDialogBase(parent, name, true, i18n("Setup Cameras"), 
                         Help|Ok|Cancel, Ok, true) 
{
    // About data and help button.

    m_about = new KIPIPlugins::KPAboutData(I18N_NOOP("KameraKlient"),
                                           0,
                                           TDEAboutData::License_GPL,
                                           I18N_NOOP("An Digital camera interface Kipi plugin"),
                                           "(c) 2003-2004, Renchi Raju\n"
                                           "(c) 2004, Tudor Calin");
    
    m_about->addAuthor("Renchi Raju", I18N_NOOP("Original author from Digikam project"),
                       "renchi@pooh.tam.uiuc.edu");

    m_about->addAuthor("Tudor Calin", I18N_NOOP("Porting the Digikam GPhoto2 interface to Kipi. Maintainer"),
                       "tudor@1xtech.com");

    helpButton_ = actionButton( Help );
    KHelpMenu* helpMenu = new KHelpMenu(this, m_about, false);
    helpMenu->menu()->removeItemAt(0);
    helpMenu->menu()->insertItem(i18n("Plugin Handbook"), this, TQT_SLOT(slotHelp()), 0, -1, 0);
    helpButton_->setPopup( helpMenu->menu() );
        
    setWFlags(TQt::WDestructiveClose);
    TQWidget *page = new TQWidget(this);
    setMainWidget(page);
    TQVBoxLayout* vbox = new TQVBoxLayout(page, 5, 5); 
        
    //---------------------------------------------
        
    TQGroupBox* groupBox = new TQGroupBox(page, "groupBox");
    groupBox->setColumnLayout(0, Qt::Vertical);
    groupBox->layout()->setSpacing(5);
    groupBox->layout()->setMargin(5);
    
    TQGridLayout* groupBoxLayout = new TQGridLayout(groupBox->layout());
    groupBoxLayout->setAlignment( TQt::AlignTop );
    listView_ = new TQListView( groupBox );
    listView_->addColumn(i18n("Model"));
    listView_->addColumn(i18n("Port"));
    listView_->setAllColumnsShowFocus(true); 
    groupBoxLayout->addMultiCellWidget(listView_, 0, 4, 0, 0);
    addButton_ = new TQPushButton(groupBox);
    groupBoxLayout->addWidget(addButton_, 0, 1);
    removeButton_ = new TQPushButton(groupBox);
    groupBoxLayout->addWidget(removeButton_, 1, 1);
    editButton_ = new TQPushButton( groupBox);
    groupBoxLayout->addWidget(editButton_, 2, 1);
    autoDetectButton_ = new TQPushButton(groupBox);
    groupBoxLayout->addWidget(autoDetectButton_, 3, 1);
    addButton_->setText( i18n("Add..."));
    removeButton_->setText( i18n( "Remove"));
    editButton_->setText( i18n("Edit..."));
    autoDetectButton_->setText(i18n("Auto-Detect"));
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    groupBoxLayout->addItem(spacer, 4, 1);
    vbox->addWidget(groupBox);
    removeButton_->setEnabled(false);
    editButton_->setEnabled(false);
    
    connect(listView_, TQT_SIGNAL(selectionChanged()), this, TQT_SLOT(slotSelectionChanged()));
    connect(addButton_, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotAddCamera()));
    connect(removeButton_, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotRemoveCamera()));
    connect(editButton_, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotEditCamera()));
    connect(autoDetectButton_, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotAutoDetectCamera()));
    
    CameraList* clist = CameraList::instance();
        
    if(clist) {
        TQPtrList<CameraType>* cl = clist->cameraList();
        for (CameraType *ctype = cl->first(); ctype; ctype = cl->next()) {
        new TQListViewItem(listView_, ctype->model(), ctype->port());
        }
    }
    
    connect(this, TQT_SIGNAL(okClicked()), this, TQT_SLOT(slotOkClicked()));
    
    show();
    int W=SetupCamera::width (), H=SetupCamera::height();
    move(TQApplication::desktop()->width ()/2-(W/2), TQApplication::desktop()->height()/2-(H/2));
}

SetupCamera::~SetupCamera() {
    delete m_about;
}

void SetupCamera::slotHelp()
{
    TDEApplication::kApplication()->invokeHelp("kameraklient",
                                             "kipi-plugins");
}   

void SetupCamera::slotSelectionChanged() {
    TQListViewItem *item = listView_->selectedItem();
    if (!item) {
	removeButton_->setEnabled(false);
	editButton_->setEnabled(false);
	return;
    }
    removeButton_->setEnabled(true);
    editButton_->setEnabled(true);
}

void SetupCamera::slotAddCamera() {
	CameraSelection *select = new CameraSelection;
	connect(select, TQT_SIGNAL(signalOkClicked(const TQString&, const TQString&)),
			this, TQT_SLOT(slotAddedCamera(const TQString&, const TQString&)));
	select->show();
}

void SetupCamera::slotRemoveCamera() {
	TQListViewItem *item = listView_->currentItem();
	if (!item) {
	    return;
	}
	delete item;
}

void SetupCamera::slotEditCamera() {
	TQListViewItem *item = listView_->currentItem();
	if (!item) {
	    return;
	}
	CameraSelection *select = new CameraSelection;
	select->setCamera(item->text(0), item->text(1));
	connect(select, TQT_SIGNAL(signalOkClicked(const TQString&, const TQString&)),
			this, TQT_SLOT(slotEditedCamera(const TQString&, const TQString&)));
	select->show();
}

void SetupCamera::slotAutoDetectCamera() {
    TQString model, port;
    if (GPIface::autoDetect(model, port) != 0) {
	KMessageBox::error(this, i18n("Failed to auto-detect camera!\n" "Please retry or try setting manually."));
	return;
    }
    bool found = false;
    CameraList* clist = CameraList::instance();
    if (clist) {
	if (clist->find(model)) {
	    found = true;
	}
    }
    if (found) {
	KMessageBox::information(this, i18n("Already added camera: ") + model + " (" + port + ")");
    } else {
	KMessageBox::information(this, i18n("Found camera: ") + model + " (" + port + ")");
	new TQListViewItem(listView_, model, port, "/");
    }
}

void SetupCamera::slotAddedCamera(const TQString& model, const TQString& port) {
    new TQListViewItem(listView_, model, port);
}

void SetupCamera::slotEditedCamera(const TQString& model, const TQString& port) {
    TQListViewItem *item = listView_->currentItem();
    if (!item) {
	return;
    }
    item->setText(0, model);
    item->setText(1, port);
}

void SetupCamera::applySettings() {
    CameraList* clist = CameraList::instance();
    if(clist) {
	clist->clear();
	TQListViewItemIterator it(listView_);
	for( ; it.current(); ++it ) {
	    TQListViewItem *item = it.current();
	    CameraType *ctype = new CameraType(item->text(0), item->text(1));
	    clist->insert(ctype);
	}
    }
}

void SetupCamera::slotOkClicked() {
    applySettings();
    close();
}

}  // NameSpace KIPIKameraKlientPlugin

#include "setupcamera.moc"
