// This module defines various things common to all of the TQt port to
// Scintilla.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLAGLOBAL_H
#define TQEXTSCINTILLAGLOBAL_H


#include <tqglobal.h>


#define	TQSCINTILLA_VERSION	0x010701
#define	TQSCINTILLA_VERSION_STR	"1.7.1"
#define	TQSCINTILLA_BUILD	"@RM_BUILD@"


// Under Windows, define TQEXTSCINTILLA_MAKE_DLL to create a Scintilla DLL, or
// define TQEXTSCINTILLA_DLL to link against a Scintilla DLL, or define neither
// to either build or link against a static Scintilla library.
#if defined(TQ_WS_WIN)

#if defined(TQEXTSCINTILLA_DLL)
#define	TQEXTSCINTILLA_EXPORT	__declspec(dllimport)
#elif defined(TQEXTSCINTILLA_MAKE_DLL)
#define	TQEXTSCINTILLA_EXPORT	__declspec(dllexport)
#endif

#else

#if __GNUC__ >= 4
#define TQEXTSCINTILLA_EXPORT __attribute__ ((visibility("default")))
#endif

#endif

#if !defined(TQEXTSCINTILLA_EXPORT)
#define	TQEXTSCINTILLA_EXPORT
#endif


#endif
