#!/usr/bin/env python

"""**************************************************************************
** $Id: fonts.py,v 1.1 2003/07/01 14:18:37 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from python_tqt.qt import *

class Viewer( TQWidget ):
    def __init__( self ):
        TQWidget.__init__( self )

        self.setFontSubstitutions()

        #greeting_heb = TQString.fromUtf8( "\327\251\327\234\327\225\327\235" )
        greeting_heb = unicode( '\327\251\327\234\327\225\327\235','utf8' )
        #greeting_ru  = TQString.fromUtf8( "\320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265" )
        greeting_ru  = unicode('\320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265','utf8' )
        greeting_en  = "Hello"

        self.greetings = TQTextView( self, "textview" )

        self.greetings.setText( greeting_en + "\n" +
                                greeting_ru + "\n" +
                                greeting_heb )

        self.fontInfo = TQTextView( self, "fontinfo" )
        
        self.setDefault()

        self.defaultButton = TQPushButton( "Default", self, "pushbutton1" )
        self.defaultButton.setFont( TQFont( "times" ) )
        self.connect( self.defaultButton, SIGNAL("clicked()"), self.setDefault )

        self.sansSerifButton = TQPushButton( "Sans Serif", self, "pushbutton2" )
        self.sansSerifButton.setFont( TQFont( "Helvetica", 12 ) )
        self.connect( self.sansSerifButton, SIGNAL("clicked()"), self.setSansSerif )

        self.italicsButton = TQPushButton( "Italics", self, "pushbutton3" )
        self.italicsButton.setFont( TQFont( "lucida", 12, TQFont.Bold, True ) )
        self.connect( self.italicsButton, SIGNAL("clicked()"), self.setItalics )

        self.layout()

    def setDefault( self ):
        font = TQFont( "Bavaria" )
        font.setPointSize( 24 )
        font.setWeight( TQFont.Bold )
        font.setUnderline( True )
        
        self.greetings.setFont( font )
        
        self.showFontInfo( font )

    def setSansSerif( self ):
        font = TQFont( "Newyork", 18 )
        font.setStyleHint( TQFont.SansSerif )
        
        self.greetings.setFont( font )

        self.showFontInfo( font )

    def setItalics( self ):
        font = TQFont( "Tokyo" )
        font.setPointSize( 32 )
        font.setWeight( TQFont.Bold )
        font.setItalic( True )

        self.greetings.setFont( font )

        self.showFontInfo( font )

    def showFontInfo( self, font ):
        info = TQFontInfo( font )

        messageText = "Font requested: \"" + str(font.family()) + "\" " \
                      + str(TQString.number( font.pointSize() )) + "pt<BR>" \
                      + "Font used: \"" + str(info.family()) + "\" " \
                      + str(TQString.number( info.pointSize() )) + "pt<P>"

        if not self.substitutes.isEmpty() :
            messageText += "The following substitutions exist for " + \
                           str(font.family()) + ":<UL>"
            for i in self.substitutes :
                messageText += "<LI>\"" + str(i) + "\""
            messageText += "</UL>";
        else :
            messageText += "No substitutions exist for " + \
                           str(font.family()) + "."

        self.fontInfo.setText( messageText )

    def setFontSubstitutions( self ):
        self.substitutes = TQStringList()
        self.substitutes.append( "Times" )
        self.substitutes.append( "Mincho" )
        self.substitutes.append( "Arabic Newspaper" )
        self.substitutes.append( "crox" )
        #TQFont.insertSubstitutions( "Bavaria", self.substitutes )
        TQFont.insertSubstitution( "Bavaria", "Times" )
        TQFont.insertSubstitution( "Tokyo", "Lucida" )
           
    # For those who prefer to use TQt Designer for creating GUIs        
    # the following function might not be of particular interest:
    # all it does is creating the widget layout.
    def layout( self ):
        textViewContainer = TQHBoxLayout()
        textViewContainer.addWidget( self.greetings )
        textViewContainer.addWidget( self.fontInfo )

        buttonContainer = TQHBoxLayout()
        buttonContainer.addWidget( self.defaultButton )
        buttonContainer.addWidget( self.sansSerifButton )
        buttonContainer.addWidget( self.italicsButton )

        maxButtonHeight = self.defaultButton.height()

        if self.sansSerifButton.height() > maxButtonHeight :
            maxButtonHeight = self.sansSerifButton.height()
        if self.italicsButton.height() > maxButtonHeight :
            maxButtonHeight = self.italicsButton.height()

        self.defaultButton.setFixedHeight( maxButtonHeight )
        self.sansSerifButton.setFixedHeight( maxButtonHeight )
        self.italicsButton.setFixedHeight( maxButtonHeight )

        container = TQVBoxLayout( self )
        container.addLayout( textViewContainer )
        container.addLayout( buttonContainer )

        self.resize( 700, 250 )
    
def main( args ):
    app = TQApplication(sys.argv)          # application object
    
    textViewer = Viewer()
    textViewer.setCaption( "TQt Example - Simple TQFont Demo" )
    app.setMainWidget( textViewer )
    textViewer.show()
    
    app.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
