#!/usr/bin/env python

# vim:tabstop=2:shiftwidth=2:expandtab:cinoptions=(s,U1,m1
# Copyright (C) 2002 Oleksandr Yakovlyev (yshurik) <yshurik@thekompany.com>

import sys 
from python_tqt.qt import *

TRUE = 1
FALSE = 0 

class CheckLists(TQWidget):
	def __init__(self, *args):
		apply( TQWidget.__init__, (self, ) + args )

		lay = TQHBoxLayout(self)
		lay.setMargin(5)
		
		vbox1 = TQVBoxLayout(lay)
		vbox1.setMargin(5)

		# First child: a Label
		vbox1.addWidget(TQLabel("Check some items!", self))

		# Second child: the ListView
		self.lv1 = TQListView(self)
		vbox1.addWidget(self.lv1)
		self.lv1.addColumn("Items")
		self.lv1.setRootIsDecorated(TRUE)

		# create a list with 4 ListViewItems which will be parent items of other ListViewItems

		parentList = []

    parentList.append( TQListViewItem( self.lv1, "Parent Item 1" ) )
    parentList.append( TQListViewItem( self.lv1, "Parent Item 2" ) )
    parentList.append( TQListViewItem( self.lv1, "Parent Item 3" ) )
    parentList.append( TQListViewItem( self.lv1, "Parent Item 4" ) )

    num = 0

    self.childList1 = []
    # go through the list of parent items...
    for i in range(4):
      it = parentList[i]
      it.setOpen( TRUE )
			
      # ...and create 5 checkable child ListViewItems for each parent item
      for j in range(5):
        ci = TQCheckListItem( it, TQString("%1. Child of Parent %2").arg( j ).arg( i ), TQCheckListItem.CheckBox )
        self.childList1.append(ci)

    # Create another widget for layouting
    tmp1 = TQVBoxLayout( lay )
    tmp1.setMargin( 5 )

    # create a pushbutton
    copy1 = TQPushButton( "  ->  ", self )
    tmp1.addWidget( copy1 )
    copy1.setMaximumWidth( copy1.sizeHint().width() );
    # connect the SIGNAL clicked() of the pushbutton with the SLOT copy1to2()
    self.connect( copy1, SIGNAL('clicked()'), self.copy1to2 )

    # another widget for layouting
    vbox2 = TQVBoxLayout( lay )
    vbox2.setMargin( 5 )

    # and another label
    vbox2.addWidget( TQLabel( "Check one item!", self ) )

    # create the second listview
    self.lv2 = TQListView( self )
    vbox2.addWidget( self.lv2 )
    self.lv2.addColumn( "Items" )
    self.lv2.setRootIsDecorated( TRUE )

    # another widget needed for layouting only
    tmp2 = TQVBoxLayout( lay )
    tmp2.setMargin( 5 )

    # create another pushbutton...
    copy2 = TQPushButton( "  ->  ", self )
    lay.addWidget( copy2 )
    copy2.setMaximumWidth( copy2.sizeHint().width() )
    # ...and connect its clicked() SIGNAL to the copy2to3() SLOT
    self.connect( copy2, SIGNAL('clicked()'), self.copy2to3 )

    tmp3 = TQVBoxLayout( lay )
    tmp3.setMargin( 5 )

    # and create a label which will be at the right of the window
    self.label = TQLabel( "No Item yet...", self )
    tmp3.addWidget( self.label )

	def copy1to2(self):
    self.lv2.clear()

    # Insert first a controller Item into the second ListView. Always if Radio-ListViewItems
    # are inserted into a Listview, the parent item of these MUST be a controller Item!
    item = TQCheckListItem( self.lv2, "Controller", TQCheckListItem.Controller )
    item.setOpen( TRUE )

    self.listChild2 = []
    for it in self.childList1:
      # ...check state of childs, and...
      if it.parent() != None:
        # ...if the item is checked...
        if it.isOn():
          # ...insert a Radio-ListViewItem with the same text into the second ListView
          ri = TQCheckListItem(item , it.text(0), TQCheckListItem.RadioButton)
          self.listChild2.append(ri)

    if item.firstChild() != None:
      item.firstChild().setOn(TRUE)

  def copy2to3(self):
    self.label.setText( "No Item checked" )

    # iterate through the second ListView...
    for it in self.listChild2:
      # ...check state of childs, and...
      if it.parent() != None:
        # ...if the item is checked...
        if it.isOn():
          # ...set the text of the item to the label
          self.label.setText( it.text( 0 ) )

a = TQApplication(sys.argv)

checkLists = CheckLists()
checkLists.resize(700, 400)
checkLists.setCaption("PyTQt example - CheckLists")

a.setMainWidget(checkLists)
checkLists.show()
a.exec_loop()
