/***************************************************************************
 * $Id: paranoia.ui.h,v 1.5 2008/07/31 19:56:26 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include "torkconfig.h"
#include <tdelocale.h>
#include <ntqtooltip.h>
#include <ntqpopupmenu.h>
#include <kdebug.h>
#include <kiconloader.h>


void FilterTable::init()
{
    FilterRules->setSelectionMode( TQListView::Extended );
    FilterRules->setColumnWidthMode(0, TQListView::Manual);
    FilterRules->hideColumn(0);
    FilterRules->header()->setResizeEnabled(FALSE, 0);
    FilterRules->setResizeMode( TQListView::NoColumn );

    SystemFilterRules->setSelectionMode( TQListView::Extended );
    SystemFilterRules->setColumnWidthMode(0, TQListView::Manual);
    SystemFilterRules->hideColumn(0);
    SystemFilterRules->header()->setResizeEnabled(FALSE, 0);
    SystemFilterRules->setResizeMode( TQListView::NoColumn );

    TQStringList filterRules = TorkConfig::filterRules();

    TQListViewItem *tm;
	for ( TQStringList::Iterator it = filterRules.begin(); it != filterRules.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString active = (*it).section("%:%",0,0);
        TQString desc = (*it).section("%:%",1,1);
        TQString entry = (*it).section("%:%",2,2);
        
        tm = new TQListViewItem(FilterRules,active,desc,entry);

        tm->setPixmap( 1, TQPixmap(SmallIcon(active )));
    }


    TQStringList systemFilterRules = TorkConfig::systemFilterRules();

	for ( TQStringList::Iterator it = systemFilterRules.begin(); it != systemFilterRules.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString active = (*it).section("%:%",0,0);
        TQString desc = (*it).section("%:%",1,1);
        TQString entry = (*it).section("%:%",2,2);
        
        tm = new TQListViewItem(SystemFilterRules,active,desc,entry);

        tm->setPixmap( 1, TQPixmap(SmallIcon(active )));
    }


}

void FilterTable::pushAdd_clicked()
{
    new TQListViewItem(FilterRules,Description->text().replace("%:%",""),Filter->text().replace("%:%",""));

}

void FilterTable::pushAdd_Sys_clicked()
{
    new TQListViewItem(SystemFilterRules,SystemDescription->text().replace("%:%",""),SystemFilter->text().replace("%:%",""));

}


void FilterTable::FilterRules_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( FilterRules );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->insertItem( "Toggle Entry", this,SLOT(slotToggleEntry()) );

    menu->popup( point );

}

void FilterTable::SystemFilterRules_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( SystemFilterRules );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteSystemEntry()) );
    menu->insertItem( "Toggle Entry", this,SLOT(slotToggleSystemEntry()) );

    menu->popup( point );

}


void FilterTable::slotDeleteEntry( )
{

    TQListViewItemIterator it(FilterRules, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (FilterRules->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}

void FilterTable::slotToggleEntry( )
{

    TQListViewItemIterator it(FilterRules, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (FilterRules->isSelected( it.current())){
            TQString active = "button_cancel";
            if (it.current()->text(0).contains("button_cancel"))
                active = "button_ok";

            it.current()->setText(0,active);
            it.current()->setPixmap( 1, TQPixmap(SmallIcon(active)));
        }
        ++it;
    }


}

void FilterTable::slotDeleteSystemEntry( )
{

    TQListViewItemIterator it(SystemFilterRules, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SystemFilterRules->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}

void FilterTable::slotToggleSystemEntry( )
{

    TQListViewItemIterator it(SystemFilterRules, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SystemFilterRules->isSelected( it.current())){
            TQString active = "button_cancel";
            if (it.current()->text(0).contains("button_cancel"))
                active = "button_ok";

            it.current()->setText(0,active);
            it.current()->setPixmap( 1, TQPixmap(SmallIcon(active)));
        }
        ++it;
    }


}

// <connections>
//     <connection>
//         <sender>pushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>FilterTable</receiver>
//         <slot>pushAdd_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>FilterRules</sender>
//         <signal>contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</signal>
//         <receiver>FilterTable</receiver>
//         <slot>FilterRules_contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">firewallsproxies.ui.h</include>
// </includes>
// <slots>
//     <slot>pushAdd_clicked()</slot>
//     <slot>FilterRules_contextMenuRequested( TQListViewItem *, const TQPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>
