/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef TDEIOLISTENER_H
#define TDEIOLISTENER_H

#include "context_listener.hpp"
#include "pwstorage.h"

namespace TDEIO {
    class SlaveBase;
    class tdeio_svnProtocol;

/**
@author Rajko Albrecht
*/
class KioListener : public svn::ContextListener
{
public:
    KioListener(TDEIO::tdeio_svnProtocol*_par);
    virtual ~KioListener();

    /* context-listener methods */
    virtual bool contextGetLogin (const TQString & realm,
                     TQString & username,
                     TQString & password,
                     bool & maySave);
    virtual bool contextGetSavedLogin (const TQString & realm,TQString & username,TQString & password);
    virtual bool contextGetCachedLogin (const TQString & realm,TQString & username,TQString & password);

    virtual void contextNotify (const char *path,
                   svn_wc_notify_action_t action,
                   svn_node_kind_t kind,
                   const char *mime_type,
                   svn_wc_notify_state_t content_state,
                   svn_wc_notify_state_t prop_state,
                   svn_revnum_t revision);
    virtual void contextNotify (const svn_wc_notify_t *action);

    virtual bool contextCancel();
    virtual bool contextGetLogMessage (TQString & msg,const svn::CommitItemList&);
    virtual SslServerTrustAnswer contextSslServerTrustPrompt (const SslServerTrustData & data,
                                 apr_uint32_t & acceptedFailures);
    virtual bool contextSslClientCertPrompt (TQString & certFile);
    virtual bool contextSslClientCertPwPrompt (TQString & password,
                                   const TQString & realm, bool & maySave);
    virtual bool contextLoadSslClientCertPw(TQString&password,const TQString&realm);
    /* context listener virtuals end */
    unsigned int counter()const{return m_notifyCounter;}
    void incCounter(){++m_notifyCounter;}
    virtual void contextProgress(long long int current, long long int max);

    void setCancel(bool value){m_Canceld=value;}

private:
    TDEIO::tdeio_svnProtocol *par;

protected:
    unsigned int  m_notifyCounter;
    bool m_External;
    bool m_HasChanges;
    bool m_FirstTxDelta;
    bool m_Canceld;
};
}

#endif
