/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef REVGRAPHVIEW_H
#define REVGRAPHVIEW_H

#include <svnqt/revision.hpp>

#include <tqcanvas.h>

namespace svn {
    class LogEntry;
    class Client;
}

class KTempFile;
class TDEProcess;
class RevisionTree;
class GraphTreeLabel;
class GraphViewTip;
class GraphMark;
class PannerView;
class CContextListener;

/**
	@author Rajko Albrecht <ral@alwins-world.de>
*/
class RevGraphView : public TQCanvasView
{
    Q_OBJECT
  
public:
    enum ZoomPosition { TopLeft, TopRight, BottomLeft, BottomRight, Auto };
    /* avoid large copy operations */
    friend class RevisionTree;

    RevGraphView(TQObject*,svn::Client*,TQWidget * parent = 0, const char * name = 0, WFlags f = 0);
    virtual ~RevGraphView();

    void showText(const TQString&s);
    void clear();

    void beginInsert();
    void endInsert();

    struct targetData {
        char Action;
        TQString key;
        targetData(const TQString&n,char _a)
        {
            key = n;
            Action = _a;
        }
        targetData(){Action=0;key="";}
    };
    typedef TQValueList<targetData> tlist;

    struct keyData {
        TQString name,Author,Date,Message;
        long rev;
        char Action;
        tlist targets;
    };

    typedef TQMap<TQString,keyData> trevTree;

    TQString toolTip(const TQString&nodename,bool full=false)const;

    void setBasePath(const TQString&);
    void dumpRevtree();

signals:
    void dispDetails(const TQString&);
    void makeCat(const svn::Revision&,const TQString&,const TQString&,const svn::Revision&,TQWidget*);
    void makeNorecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
    void makeRecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);

public slots:
    virtual void contentsMovingSlot(int,int);
    virtual void zoomRectMoved(int,int);
    virtual void zoomRectMoveFinished();
    virtual void slotClientException(const TQString&what);

protected slots:
    virtual void readDotOutput(TDEProcess *   proc,char *   buffer,int   buflen);
    virtual void dotExit(TDEProcess*);

protected:
    TQCanvas*m_Canvas;
    GraphMark*m_Marker;
    svn::Client*m_Client;
    GraphTreeLabel*m_Selected;
    TQObject*m_Listener;
    KTempFile*dotTmpFile;
    TQString dotOutput;
    TDEProcess*renderProcess;
    trevTree m_Tree;
    TQColor getBgColor(const TQString&nodeName)const;
    bool isStart(const TQString&nodeName)const;
    char getAction(const TQString&)const;
    const TQString&getLabelstring(const TQString&nodeName);

    TQMap<TQString,GraphTreeLabel*> m_NodeList;
    TQMap<TQString,TQString> m_LabelMap;

    int _xMargin,_yMargin;
    GraphViewTip*m_Tip;
    PannerView*m_CompleteView;
    double _cvZoom;
    ZoomPosition m_LastAutoPosition;

    virtual void resizeEvent(TQResizeEvent*);
    virtual void contentsMousePressEvent ( TQMouseEvent * e );
    virtual void contentsMouseReleaseEvent ( TQMouseEvent * e );
    virtual void contentsMouseMoveEvent ( TQMouseEvent*e);
    virtual void contentsContextMenuEvent(TQContextMenuEvent*e);
    virtual void contentsMouseDoubleClickEvent ( TQMouseEvent * e );

    bool _isMoving;
    TQPoint _lastPos;

    bool _noUpdateZoomerPos;

    TQString _basePath;

private:
    void updateSizes(TQSize s = TQSize(0,0));
    void updateZoomerPos();
    void setNewDirection(int dir);
    void makeDiffPrev(GraphTreeLabel*);
    void makeDiff(const TQString&,const TQString&);
    void makeSelected(GraphTreeLabel*);
    void makeCat(GraphTreeLabel*_l);
};

#endif
