/***************************************************************************
                          displaycfg.h  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_DISPLAYCFG_H
#define KRADIO_DISPLAYCFG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "displaycfg_interfaces.h"
#include <tqwidget.h>

class KColorButton;
class TDEFontChooser;

class DisplayConfiguration : public TQWidget,
                             public IDisplayCfgClient
{
Q_OBJECT
  
public:
    DisplayConfiguration(TQWidget *parent);
    ~DisplayConfiguration();

// Interface

    bool connectI (Interface *i) { return IDisplayCfgClient::connectI(i); }
    bool disconnectI (Interface *i)  { return IDisplayCfgClient::disconnectI(i); }

// IDisplayCfgClient

RECEIVERS:
    bool noticeDisplayColorsChanged(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd);
    bool noticeDisplayFontChanged(const TQFont &f);


public slots:

    void slotOK();
    void slotCancel();
    void slotSetDirty();

signals:

    void sigDirty();

protected:
    KColorButton *m_btnActive;
    KColorButton *m_btnInactive;
    KColorButton *m_btnBkgnd;
    TDEFontChooser *m_fontChooser;

    bool          m_dirty;
    bool          m_ignore_gui_updates;
};


#endif
