/***************************************************************************
    smb4kuserinterfaceoptions  -  This configuration page takes care
    of all settings concerning the user interface of Smb4K
                             -------------------
    begin                : Mi Aug 30 2006
    copyright            : (C) 2006-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

// KDE includes
#include <tdelocale.h>

// application specific includes
#include "smb4kuserinterfaceoptions.h"
#include "../core/smb4ksettings.h"

Smb4KUserInterfaceOptions::Smb4KUserInterfaceOptions( TQWidget *parent, const char *name )
: TQTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // Configuration for the main window:
  //
  TQWidget *main_wd_widget     = new TQWidget( this );
  TQGridLayout *main_wd_layout = new TQGridLayout( main_wd_widget );
  main_wd_layout->setSpacing( 10 );

  TQButtonGroup *shares_view   = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Shares View" ),
                                main_wd_widget, "kcfg_SharesView" );

  shares_view->insert( new TQRadioButton( i18n( "Show mounted shares in an icon view" ), shares_view ), Smb4KSettings::EnumSharesView::IconView );

  shares_view->insert( new TQRadioButton( i18n( "Show mounted shares in a list view" ), shares_view ), Smb4KSettings::EnumSharesView::ListView );

  TQButtonGroup *bookmarks_grp = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Bookmarks" ),
                                main_wd_widget, "BookmarksBox" );

  (void) new TQCheckBox( i18n( "Show custom bookmark label if available" ), bookmarks_grp, "kcfg_ShowCustomBookmarkLabel" );

  TQButtonGroup *tray_group    = new TQButtonGroup( 1, Qt::Horizontal, i18n( "System Tray" ),
                                main_wd_widget, "SystemTrayBox" );

  (void) new TQCheckBox( i18n( "Embed application into the system tray" ), tray_group, "kcfg_EmbedIntoSystemTray" );

  TQSpacerItem *spacer1 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  main_wd_layout->addWidget( shares_view, 0, 0, 0 );
  main_wd_layout->addWidget( bookmarks_grp, 1, 0, 0 );
  main_wd_layout->addWidget( tray_group, 2, 0, 0 );
  main_wd_layout->addItem( spacer1, 3, 0 );

  //
  // Configuration for the network browser:
  //
  TQWidget *browser_widget =     new TQWidget( this );
  TQGridLayout *browser_layout = new TQGridLayout( browser_widget );
  browser_layout->setSpacing( 10 );

  TQButtonGroup *remoteGroup = new TQButtonGroup( 2, Qt::Horizontal, i18n( "Remote Shares" ),
                              browser_widget, "BrowserRemoteSharesBox" );
  (void) new TQCheckBox( i18n( "Show printer shares" ), remoteGroup, "kcfg_ShowPrinterShares" );
  TQCheckBox *hidden = new TQCheckBox( i18n( "Show hidden shares" ), remoteGroup, "kcfg_ShowHiddenShares" );
  (void) new TQCheckBox( i18n( "Show IPC$ shares" ), remoteGroup, "kcfg_ShowHiddenIPCShares" );
  (void) new TQCheckBox( i18n( "Show ADMIN$ shares" ), remoteGroup, "kcfg_ShowHiddenADMINShares" );

  TQButtonGroup *columnsGroup = new TQButtonGroup( 2, Qt::Horizontal, i18n( "Columns" ),
                               browser_widget, "BrowserColumnsBox" );
  (void) new TQCheckBox( i18n( "Show type" ), columnsGroup, "kcfg_ShowType" );
  (void) new TQCheckBox( i18n( "Show IP address" ), columnsGroup, "kcfg_ShowIPAddress" );
  (void) new TQCheckBox( i18n( "Show comment" ), columnsGroup, "kcfg_ShowComment" );

  TQButtonGroup *netTooltipsGroup = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Tooltips" ),
                                   browser_widget, "BrowserTooltipsBox" );
  (void) new TQCheckBox( i18n( "Show tooltip with information about a network item" ), netTooltipsGroup, "kcfg_ShowNetworkItemToolTip" );

  TQSpacerItem *spacer2 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  browser_layout->addWidget( remoteGroup, 0, 0, 0 );
  browser_layout->addWidget( columnsGroup, 1, 0, 0 );
  browser_layout->addWidget( netTooltipsGroup, 2, 0, 0 );
  browser_layout->addItem( spacer2, 3, 0 );

  //
  // Configuration for the shares view
  //
  TQWidget *shares_widget =     new TQWidget( this );
  TQGridLayout *shares_layout = new TQGridLayout( shares_widget );
  shares_layout->setSpacing( 10 );

  TQButtonGroup *shares_group = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Mounted Shares" ),
                              shares_widget, "SharesIconGroupBox" );
  (void) new TQCheckBox( i18n( "Show mount point instead of share name" ), shares_group, "kcfg_ShowMountPoint" );
  (void) new TQCheckBox( i18n( "Show all shares that are mounted on the system" ), shares_group, "kcfg_ShowAllShares" );

  TQButtonGroup *dnd_group = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Drag and Drop" ),
                            shares_widget, "DragnDropBox" );
  (void) new TQCheckBox( i18n( "Allow dropping of files and directories onto shares" ), dnd_group, "kcfg_EnableDropSupport" );
  (void) new TQCheckBox( i18n( "Allow dragging of shares" ), dnd_group, "kcfg_EnableDragSupport" );

  TQButtonGroup *sharesTooltipGroup = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Tooltips" ),
                                     shares_widget, "SharesTooltipsBox" );
  (void) new TQCheckBox( i18n( "Show tooltip with information about a share" ), sharesTooltipGroup, "kcfg_ShowShareToolTip" );

  TQButtonGroup *list_view_group = new TQButtonGroup( 2, Qt::Horizontal, i18n( "List View" ),
                                  shares_widget, "SharesListViewBox" );

#ifndef __FreeBSD__
  (void) new TQCheckBox( i18n( "Show owner and group (SMBFS only)" ), list_view_group, "kcfg_ShowOwner" );    
  (void) new TQCheckBox( i18n( "Show login (CIFS only)" ), list_view_group, "kcfg_ShowLogin" );
#else
  (void) new TQCheckBox( i18n( "Show owner and group" ), list_view_group, "kcfg_ShowOwner" );    
#endif
  (void) new TQCheckBox( i18n( "Show file system" ), list_view_group, "kcfg_ShowFileSystem" );
  (void) new TQCheckBox( i18n( "Show free disk space" ), list_view_group, "kcfg_ShowFreeDiskSpace" );
  (void) new TQCheckBox( i18n( "Show used disk space" ), list_view_group, "kcfg_ShowUsedDiskSpace" );
  (void) new TQCheckBox( i18n( "Show total disk space" ), list_view_group, "kcfg_ShowTotalDiskSpace" );
  (void) new TQCheckBox( i18n( "Show disk usage" ), list_view_group, "kcfg_ShowDiskUsage" );

  TQSpacerItem *spacer3 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  shares_layout->addWidget( shares_group, 0, 0, 0 );
  shares_layout->addWidget( dnd_group, 1, 0, 0 );
  shares_layout->addWidget( sharesTooltipGroup, 2, 0, 0 );
  shares_layout->addWidget( list_view_group, 3, 0, 0 );
  shares_layout->addItem( spacer3, 4, 0 );

  //
  // Configuration for the preview dialog
  //
  TQWidget *preview_widget =     new TQWidget( this );
  TQGridLayout *preview_layout = new TQGridLayout( preview_widget );
  preview_layout->setSpacing( 10 );

  TQButtonGroup *previewFilesGroup = new TQButtonGroup( 1, Qt::Horizontal, i18n( "Hidden Files and Directories" ), preview_widget, "HiddenFilesBox" );
  (void) new TQCheckBox( i18n( "Preview hidden files and directories" ), previewFilesGroup, "kcfg_PreviewHiddenItems" );

  TQSpacerItem *spacer4 = new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  preview_layout->addWidget( previewFilesGroup, 0, 0, 0 );
  preview_layout->addItem( spacer4, 1, 0 );

  //
  // Add tabs:
  //
  addTab( main_wd_widget, i18n( "Main Window && System Tray" ) );
  addTab( browser_widget, i18n( "Network Browser" ) );
  addTab( shares_widget, i18n( "Shares View" ) );
  addTab( preview_widget, i18n( "Preview Dialog" ) );

  // Add connections:
  connect( hidden, TQT_SIGNAL( stateChanged( int ) ),
           this,   TQT_SLOT( slotShowHiddenShares( int ) ) );

  // Do last adjustments:
  slotShowHiddenShares( hidden->state() );
}


Smb4KUserInterfaceOptions::~Smb4KUserInterfaceOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KUserInterfaceOptions::slotShowHiddenShares( int state )
{
  if ( state == TQCheckBox::On )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "kcfg_ShowHiddenIPCShares", TQCHECKBOX_OBJECT_NAME_STRING )) )->setEnabled( true );
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "kcfg_ShowHiddenADMINShares", TQCHECKBOX_OBJECT_NAME_STRING )) )->setEnabled( true );
  }
  else if ( state == TQCheckBox::Off )
  {
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "kcfg_ShowHiddenIPCShares", TQCHECKBOX_OBJECT_NAME_STRING )) )->setEnabled( false );
    static_cast<TQCheckBox *>( TQT_TQWIDGET(child( "kcfg_ShowHiddenADMINShares", TQCHECKBOX_OBJECT_NAME_STRING )) )->setEnabled( false );
  }
}

#include "smb4kuserinterfaceoptions.moc"
