
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_NOTATIONCONFIGURATIONPAGE_H_
#define _RG_NOTATIONCONFIGURATIONPAGE_H_

#include <string>
#include "TabbedConfigurationPage.h"
#include <tqstring.h>
#include <tqstringlist.h>
#include <tdelocale.h>


class TQWidget;
class TQPushButton;
class TQLabel;
class TQComboBox;
class TQCheckBox;
class TDEFontRequester;
class TDEConfig;


namespace Rosegarden
{

class QuantizeParameters;


/**
 * Notation Configuration page
 */
class NotationConfigurationPage : public TabbedConfigurationPage
{
    Q_OBJECT
  

public:
    NotationConfigurationPage(TDEConfig *cfg,
                              TQWidget *parent = 0, const char *name=0);

    virtual void apply();

    static TQString iconLabel() { return i18n("Notation"); }
    static TQString title()     { return i18n("Notation"); }
    static TQString iconName()  { return "configure-notation"; }

protected slots:
    void slotFontComboChanged(int);
    void slotPopulateFontCombo(bool rescan);
    void slotViewButtonPressed();

protected:

    //--------------- Data members ---------------------------------

    TQComboBox *m_font;
    TQComboBox *m_singleStaffSize;
    TQComboBox *m_multiStaffSize;
    TQComboBox *m_printingSize;
    TDEFontRequester* m_textFont;
    TDEFontRequester* m_sansFont;
    TDEFontRequester* m_timeSigFont;
    TQPushButton *m_viewButton;
    TQLabel *m_fontOriginLabel;
    TQLabel *m_fontCopyrightLabel;
    TQLabel *m_fontMappedByLabel;
    TQLabel *m_fontTypeLabel;
    TQComboBox *m_layoutMode;
    TQComboBox *m_spacing;
    TQComboBox *m_proportion;
    TQCheckBox *m_colourQuantize;
    TQCheckBox *m_showUnknowns;
    TQCheckBox *m_showInvisibles;
    TQCheckBox *m_showRanges;
    TQCheckBox *m_showCollisions;
    TQComboBox *m_showTrackHeaders;
    TQComboBox *m_noteStyle;
    TQComboBox *m_insertType;
    TQCheckBox *m_autoBeam;
    TQCheckBox *m_collapseRests;
    TQComboBox *m_pasteType;
    TQComboBox *m_accOctavePolicy;
    TQComboBox *m_accBarPolicy;
    TQComboBox *m_keySigCancelMode;
    TQCheckBox *m_splitAndTie;
    QuantizeParameters *m_quantizeFrame;
    TQStringList m_untranslatedFont;
    TQStringList m_untranslatedNoteStyle;

    void populateSizeCombo(TQComboBox *combo, std::string font, int dfltSize);
};


}

#endif
