/****************************************************************************
**
** Definition of TDEQt4PaintDevice class
**
** Copyright (C) 2012 Timothy Pearson.  All rights reserved.
**
** This file is part of the TDE Qt4 style interface
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef TDEQT4PAINTER_H
#define TDEQT4PAINTER_H

#define TQT_NO_COMPAT_NAMES
#include "ntqpaintdevice.h"
#include "ntqbuffer.h"
#undef Qt

#include <QtGui/QPainter>
#include <QtGui/QBitmap>

class Q_EXPORT TDEQt4PaintDevice : public TQPaintDevice		// picture class
{
public:
	TDEQt4PaintDevice( QPainter * );
	~TDEQt4PaintDevice();

protected:
	bool cmd( int, TQPainter *, TQPDevCmdParam * );
	int metric( int ) const;

private:
	QPainter *m_qt4painter;
	bool m_qt4OrigClipping;
	QRegion m_qt4OrigClipRegion;
	bool m_qt4OrigWorldTransformEnabled;
	QTransform m_qt4OrigWorldTransform;

	QPoint prevPt;
	QPoint curPt;
};

#endif // TDEQT4PAINTER_H
