#include "DragWidget.h"

DragWidget::DragWidget(TQWidget *parent, const char *name, WFlags f) : TQWidget(parent,name,f)
{
	dragP=TQPoint(0,0);
	drag=false;

}
DragWidget::~DragWidget()
{

}

void DragWidget::mousePressEvent(TQMouseEvent *e)
{
	dragP=e->pos();
	gpress=e->globalPos();
	drag=true;

}
void DragWidget::mouseReleaseEvent(TQMouseEvent *)
{

	drag=false;
}
void DragWidget::mouseMoveEvent(TQMouseEvent *e)
{
	if (!drag) {
		return;
	}
	TQPoint curr(e->globalPos().x()-dragP.x(),e->globalPos().y()-dragP.y());
	TQWidget::move(curr);
	
}

#include "DragWidget.moc"
