/**********************************************************************
** Copyright (C) 2000-2003 Trolltech AS.  All rights reserved.
**
** This file is part of the TQt Assistant.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/



#ifndef INDEX_H
#define INDEX_H

#include <tqstringlist.h>
#include "kvi_pointerhashtable.h"
#include "kvi_pointerlist.h"
#include "kvi_valuelist.h"
#include <tqdatastream.h>
#include <tqobject.h>

struct Document {
    Document( int d, int f ) : docNumber( d ), frequency( f ) {}
    Document() : docNumber( -1 ), frequency( 0 ) {}
    bool operator==( const Document &doc ) const {
	return docNumber == doc.docNumber;
    }
    bool operator<( const Document &doc ) const {
	return frequency > doc.frequency;
    }
    bool operator<=( const Document &doc ) const {
	return frequency >= doc.frequency;
    }
    bool operator>( const Document &doc ) const {
	return frequency < doc.frequency;
    }
    TQ_INT16 docNumber;
    TQ_INT16 frequency;
};

TQDataStream &operator>>( TQDataStream &s, Document &l );
TQDataStream &operator<<( TQDataStream &s, const Document &l );

class Index : public TQObject
{
    Q_OBJECT
  
public:
    struct Entry {
	Entry( int d ) { documents.append( Document( d, 1 ) ); }
	Entry( KviValueList<Document> l ) : documents( l ) {}
	KviValueList<Document> documents;
    };
    struct PosEntry {
	PosEntry( int p ) { positions.append( p ); }
	KviValueList<uint> positions;
    };
    Index( const TQString &dp, const TQString &hp );
    Index( const TQStringList &dl, const TQString &hp );
    void writeDict();
    void readDict();
    int makeIndex();
    TQStringList query( const TQStringList&, const TQStringList&, const TQStringList& );
    TQString getDocumentTitle( const TQString& );
    void setDictionaryFile( const TQString& );
    void setDocListFile( const TQString& );
    void writeDocumentList();
    void readDocumentList();
    void setupDocumentList();
    const TQStringList& documentList() { return docList; };
    const TQStringList& titlesList() { return titleList; };
signals:
    void indexingProgress( int );
private slots:
    void setLastWinClosed();
private:
    void parseDocument( const TQString&, int );
    void insertInDict( const TQString&, int );
    TQStringList getWildcardTerms( const TQString& );
    TQStringList split( const TQString& );
    KviValueList<Document> setupDummyTerm( const TQStringList& );
    bool searchForPattern( const TQStringList&, const TQStringList&, const TQString& );
    void buildMiniDict( const TQString& );
    TQStringList docList;
    TQStringList titleList;
    KviPointerHashTable<TQString,Entry> dict;
    KviPointerHashTable<TQString,PosEntry> miniDict;
    uint wordNum;
    TQString docPath;
    TQString dictFile, docListFile;
    bool alreadyHaveDocList;
    bool lastWindowClosed;
};

struct Term {
    Term( const TQString &t, int f, KviValueList<Document> l )
	: term( t ), frequency( f ), documents( l ) {}
    TQString term;
    int frequency;
    KviValueList<Document>documents;
};



#define TermList KviPointerList<Term>

#endif

