/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef KSYSTEM_LOG_H
#define KSYSTEM_LOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


//TQt includes
#include <tqlistview.h>
#include <tqvaluevector.h>

//KDE includes
#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tdeconfig.h>
#include <ktabwidget.h>
#include <tdeactionclasses.h>
#include <tdepopupmenu.h>
//For compatibility with old versions of KDE
#include <tdeversion.h>

//Project includes
#include "detailDialog.h"

#include "logLevel.h"
#include "logManager.h"
#include "loadingDialog.h"

#include "findManager.h"

#include "globals.h"

//Include the right header for the management of Log Action clicking, depending of the version of KDE
#if defined(TDE_MAKE_VERSION) && (TDE_VERSION >= TDE_MAKE_VERSION(3,4,0))
	#include "slotLogAction.h"
#else
	#include "slotLogActionCompatibility.h"
#endif

#define STATUS_BAR_LINE_COUNT 1
#define STATUS_BAR_LAST_MODIFICATION 2

class LogFile;
typedef TQValueList<LogFile*> LogFiles;


class KPrinter;
class TDEToggleAction;
class KURL;

/**
 * This class serves as the main window for ksystemlog.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Nicolas Ternisien <nicolas.ternisien@gmail.com>
 * @version 0.1
 */
class KSystemLog : public TDEMainWindow {

	Q_OBJECT
  
	public:
		/**
		 * Default Constructor
		 */
		KSystemLog();
		
		/**
		 * Default Destructor
		 */
		virtual ~KSystemLog();


		groupByType getGroupBy(int& column);
		
		int getIndex(LogManager* manager);
		
		/**
		 * Specialized methods about LogManagers
		 * TODO Maybe move them to a dedicated LogManagers class 
		 * (which can subclass TQValueList<LogManager*>)
		 */
		LogManager* activeLogManager();
		
		void setCurrentLogManager(LogManager* view);
	
	
#if defined(TDE_MAKE_VERSION) && TDE_VERSION >= TDE_MAKE_VERSION(3,4,0)
		//Actual KDE method
		void logActionClicked(const TQObject* sender, TDEAction::ActivationReason reason, TQt::ButtonState state);
#else
		//Method for old versions of KDE
		void logActionClicked(const TQObject* sender);
#endif
		
		void load(LogMode* logMode, LogManager* manager);

	
	protected:
		/**
		 * Overridden virtuals for TQt drag'n drop (XDND)
		 */
		virtual void dragEnterEvent(TQDragEnterEvent *event);
		virtual void dropEvent(TQDropEvent *event);

	
	protected:
		/**
		 * This function is called when it is time for the app to save its
		 * properties for session management purposes.
		 */
		void saveProperties(TDEConfig *);
		
		/**
		 * This function is called when this app is restored.  The TDEConfig
		 * object points to the session management config file that was saved
		 * with @ref saveProperties
		 */
		void readProperties(TDEConfig *);
		
		void setupLogLevels();

	private slots:
		void fileOpen();
		void filePrint();
		
		void slotOptions();

		
	public slots:
		void changeStatusbar(const TQString& text);
		void changeCaption(const TQString& text);
		
		void changeTab(View* view, const TQString& label);
		void changeTab(View* view, const TQIconSet& icon, const TQString& label);
		
		void updateStatusBar();
		
		void updateGUI();
		
		void logUpdated(int lines);

		void slotSelectAll();
		
		void slotToggleFilterBar();
		
		void slotLogMessage();

		
		void reloadCurrent();
		void reloadAll();
		

		LogManager* newTab();
		LogManager* duplicateTab();
		
		void closeTab();
		
		void moveTabLeft();
		void moveTabRight();
		
		void logManagerReloaded();
		
		void currentTabChanged(TQWidget* view);
		
		void slotTooltipEnabled(bool enabled);
		void slotNewLinesDisplayed(bool displayed);
		
		void slotSelectionChanged(); //replace void logListSelectionChanged();
		

		void slotDetails();
		
		void groupByChanged(int group);
		
		void pauseParsing();
		void resumeParsing();

		void quit();
		
		
	private:
		//Object managing the signals come from the selection of a Log Mode
		SlotLogAction* slotLogAction;
	
		/**
		 * Get the Log Action called name from actionCollection()
		 */
		TDEToggleAction* getLogAction(const char* name);
		TDEToggleAction* getCorrespondingLogAction(LogMode* mode);
		
		void setupStatusBar();
		
		void setupTabBar();
		
		void setupProgressDialog();
		
		void setupGroupBy();
		
		void setupActions();
		void setupLogActions();

		void readConfig();
		void saveConfig();
		
		void deactiveLogActions();
		
		void updateGroupBy();
		
		LogManagers logManagers;
	
		
		KPrinter* printer;
		
		TDEAction* newTabAction;
		TDEAction* closeTabAction;
		TDEAction* duplicateTabAction;
		
		TDEAction* moveTabLeftAction;
		TDEAction* moveTabRightAction;
				
		TDEAction* saveAction;
		TDEAction* copyAction;
		
		TDEAction* sendMailAction;
		TDEAction* logMessageAction;

		TDEToggleAction* filterBarAction;

		TDEAction* reloadAction;

		TDEAction* expandAllAction;
		TDEAction* collapseAllAction;
		
		TDEAction* resumeParsingAction;
		TDEAction* pauseParsingAction;
		TDEAction* detailAction;
		
		TDEToggleAction* tooltipEnabledAction;
		TDEToggleAction* newLinesDisplayedAction;
		
		/**
		 * The Group By Action Menu
		 */
		TDEActionMenu* groupBy;

		/**
		 * A pointer to the Detail dialog
		 */
		DetailDialog* detailDialog;

		/**
		 * Loading Dialog
		 */
		LoadingDialog* loadingDialog;
	
		/**
		 * Find Manager
		 */
		FindManager* findManager;
		
		/**
		 * The tab widget managing different views
		 */
		KTabWidget* tabs;
	
		TQMap<TDEToggleAction*, LogMode*> mapActionLogModes;

};


#endif //KSYSTEM_LOG_H
