/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _FILE_LIST_H_
#define _FILE_LIST_H_

#include <tqvbox.h>
#include <tqpushbutton.h>

#include <tdepopupmenu.h>
#include <tdelistbox.h>

#include "globals.h"
#include "logLevel.h"

#define ADD_FILE_MENU_ID 0
#define REMOVE_MENU_ID 1
#define MOVE_UP_MENU_ID 2
#define MOVE_DOWN_MENU_ID 3
#define REMOVE_ALL_MENU_ID 4

//TODO Maybe draw this class with TQt Designer
class FileList : public TQWidget {

	Q_OBJECT
  
	
	public:
		FileList(TQWidget *parent, TQString description);
		~FileList();

		virtual void insertItem(TQString& item);
		virtual void removeItem(int id);
		void insertItem(TQPixmap& pixmap, TQString& item);
		
		int count();
	
		TQString getText(int i);
		
	signals:
		void fileListChanged(int itemLeft);

	protected slots:
		virtual bool updateButtons();
		
		void removeSelectedItem();
		void moveUpItem();
		void moveDownItem();
		void removeAllItem();
		virtual void addItem();
		
		void displayPopupMenu(TQListBoxItem* item, const TQPoint& point);

	protected:
		bool isValidFile(KURL url);
		
		TQVBox* buttons;
		
		TDEPopupMenu* fileListMenu;
		
		TDEListBox* fileList;
	
	private:
	
		TQPushButton* add;
		TQPushButton* remove;
		TQPushButton* up;
		TQPushButton* down;
		TQPushButton* removeAll;
	

};

#endif //_FILE_LIST_H_
