/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti
 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef OTRLCONFINTERFACE_H
#define OTRLCONFINTERFACE_H

/**
  * @author Michael Zanetti
  */

#include <tqstring.h>
#include <tqptrlist.h>
#include <tqvaluelist.h>
#include <tqthread.h>

#include <kopetechatsession.h>

extern "C" {
#include <libotr/privkey.h>
#include <libotr/proto.h>
#include <libotr/message.h>
#include <libotr/userstate.h>
#include <libotr/context.h>
}

class OtrlConfInterface
{

public:
	~OtrlConfInterface();
	OtrlConfInterface( TQWidget *preferencesDialog );

	TQString getPrivFingerprint( TQString accountId, TQString protocol );
	void generateNewPrivKey( TQString accountId, TQString protocol );
	TQValueList<TQString[5]> readAllFingerprints();
	bool hasPrivFingerprint( TQString accountId, TQString protocol);
	void forgetFingerprint( TQString strFingerprint );
	void verifyFingerprint( TQString strFingerprint, bool trust );
	bool isVerified( TQString strFingerprint );
	bool isEncrypted( TQString strFingerprint );

private:
	OtrlUserState userstate;
	TQWidget *preferencesDialog;

	Fingerprint *findFingerprint( TQString strFingerprint );	
};

#endif
