/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006 Dario Abatianni <eisfuchs@tigress.com>
*/

#ifndef WATCHEDNICKNAMES_CONFIG_H
#define WATCHEDNICKNAMES_CONFIG_H

#include "konvisettingspage.h"
#include "servergroupsettings.h"
#include "watchednicknames_preferencesui.h"


class TQListView;
class TQListViewItem;

class WatchedNicknames_Config : public WatchedNicknames_ConfigUI, public KonviSettingsPage
{
    Q_OBJECT
  

    public:
        explicit WatchedNicknames_Config(TQWidget *parent = 0, const char *name = 0);
        ~WatchedNicknames_Config();

        virtual void saveSettings();
        virtual void loadSettings();
        virtual void restorePageToDefaults();

        virtual bool hasChanged();

    signals:
        void modified();

    protected slots:
        void checkIfEmptyListview(bool state);
        void newNotify();
        void removeNotify();
        void entrySelected(TQListViewItem* notifyEntry);
        void networkChanged(const TQString& newNetwork);
        void nicknameChanged(const TQString& newNickname);
        void updateNetworkNames();

    protected:
        void enableEditWidgets(bool enabled);
        TQStringList currentNotifyList();       // for hasChanged()
        void addNetworkBranch(Konversation::ServerGroupSettingsPtr group);
        TQListViewItem* getItemById(TQListView* listView,int id);

        bool newItemSelected;
        TQStringList m_oldNotifyList;
};

#endif
