/***************************************************************************
                       main.cc - using the thesaurus KDataTool stand alone
                       -------------------
    begin            : 2001-12-22
    copyright        : (C) 2001 by Daniel Naber
    email            : daniel.naber@t-online.de
	$Id: main.cc 381440 2005-01-23 07:53:34Z mlaurent $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqstring.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdatatool.h>
#include <kdebug.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <koffice_export.h>
static TDECmdLineOptions options[] =
{
	{ "+[term]",   I18N_NOOP("Term to search for when starting up"), 0 },
	TDECmdLineLastOption
};

extern "C" KOFFICETOOLS_EXPORT int kdemain(int argc, char **argv)
{

	TDEAboutData aboutData("kthesaurus", I18N_NOOP("KThesaurus"), "1.0",
		I18N_NOOP( "KThesaurus - List synonyms" ), TDEAboutData::License_GPL,
		I18N_NOOP( "(c) 2001 Daniel Naber" ) );

	TDECmdLineArgs::init(argc, argv, &aboutData);
	TDECmdLineArgs::addCmdLineOptions(options);
	TDEApplication a; // KDataTool needs an instance

	// TODO: take term from command line!

	KService::Ptr service = KService::serviceByDesktopName("thesaurustool");
	if( ! service ) {
		kdWarning() << "Could not find Service/KDataTool 'thesaurustool'!" << endl;
		return 1;
	}

	KDataToolInfo *info = new KDataToolInfo(service, 0);
	KDataTool *tool = info->createTool();
	if ( !tool ) {
		kdWarning() << "Could not create tool 'thesaurustool'!" << endl;
		return 2;
	}

/* TODO: get selection(), not only clipboard!
	TQClipboard *cb = TQApplication::clipboard();
	TQString text = cb->text();
	if( text.isNull() || text.length() > 50 ) {
		// long texts are probably not supposed to be searched for
		text = "";
	}
*/
	TQString text = "";
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	if ( args->count() > 0 ) {
		text = args->arg(0);
	}

	TQString command = "thesaurus_standalone";	// 'standalone' will give us different buttons
	TQString mimetype = "text/plain";
	TQString datatype = TQSTRING_OBJECT_NAME_STRING;

	//kdDebug() << "KThesaurus command=" << command
	//		<< " dataType=" << info->dataType() << endl;

	tool->run(command, &text, datatype, mimetype);

	delete tool;

	return 0;
}
