
#ifndef _KWORD13LAYOUT
#define _KWORD13LAYOUT

class TQTextStream;

#include <tqstring.h>
#include <tqmap.h>

#include "kword13formatone.h"

/**
 * Layout or style
 */
class KWord13Layout
{
public:
    KWord13Layout( void );
    ~KWord13Layout( void );
    
public:
    void xmldump( TQTextStream& iostream );
    
    /**
     * @brief Get a key representating the properties
     *
     * This key helps to categorize the automatic styles
     */
    TQString key( void ) const;
    
    
    TQString getProperty( const TQString& name ) const;

public:
    KWord13FormatOneData m_format; ///< Character format properties
    TQMap<TQString,TQString> m_layoutProperties;
    bool m_outline;
    TQString m_name; ///< Name of the style (either the used one or the one currently being defined)
public: // OASIS-specific
    TQString m_autoStyleName; ///< Name of the OASIS automatic style
};

#endif // _KWORD13LAYOUT
