/***************************************************************************
 *
 * knetworkmanager-generic_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_GENERIC_CONNECTION_H
#define KNETWORKMANAGER_GENERIC_CONNECTION_H

#include <tqmap.h>
#include <tqobject.h>

#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting.h"
#include "dbus/connection.h"
#include "dbus/connectionnode.h"

class TQDBusObjectPath;

namespace ConnectionSettings
{

	class ConnectionSetting;
	class Info;

	class GenericConnection : public Connection
	{
		Q_OBJECT
  
		public:
			GenericConnection(const TQString&);
			TQString getType();

			TQString getID() const;
			void    setID(const TQString& id);

			Info* getInfoSetting() const;
	};
}
#endif /* KNETWORKMANAGER_GENERIC_CONNECTION_H */
