
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __DEVICEDIALOG_H
#define __DEVICEDIALOG_H

#include <kdialogbase.h>

/**
 * A dialog used to select a custom network device to monitor.
 * The device is specified by its interface name.
 */
class DeviceDialog : public KDialogBase {
    Q_OBJECT
  

    public:
        /**
         * Constructor.
         */
        DeviceDialog(const TQString& defaultDevice, TQWidget* parent);

        /**
         * Returns the device currently selected in the dialog.
         * This is valid after the dialog has closed, though the string
         * itself will be destroyed when this object is deleted.
         */
        const TQString& getDevice() const;

    private slots:
        /**
         * Updates the device variable to reflect the latest changes in
         * the device combo box.
         */
        virtual void updateDevice(const TQString&);

    private:
        TQString device;
            /**< The device currently selected in the device combo box. */
};

#endif
