/***************************************************************************
date                 : Sep 12 2004
version              : 0.22
copyright            : Thomas Fischer <t-fisch@users.sourceforge.net>
                       restructured, improved and completed by Holger Danielsson
                       (C) 2004 by Holger Danielsson
email                : holger.danielsson@t-online.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILEDIALOGQUICKDOCHEADER_H
#define KILEDIALOGQUICKDOCHEADER_H

#include <tqmap.h>
#include <tqvaluelist.h>
#include "kilewizard.h"

class KComboBox;
class TQListView;
class TQCheckListItem;
class KLineEdit;
class KPushButton;

namespace KileDialog
{

// some flags to check the results of the input dialog
enum {
	qd_CheckNotEmpty=1,        
	qd_CheckDocumentClass=2,
	qd_CheckClassOption=4,
	qd_CheckPackage=8,
	qd_CheckPackageOption=16,
	qd_CheckFontsize=32,
	qd_CheckPapersize=64
};

class QuickDocument : public Wizard
{
	Q_OBJECT
  

public:
	QuickDocument(TDEConfig *, TQWidget *parent=0, const char *name=0, const TQString &caption = TQString());
	~QuickDocument();

	bool isStandardClass(const TQString &classname);             
	bool isDocumentClass(const TQString &name);
	bool isDocumentClassOption(const TQString &option);
	bool isPackage(const TQString &package);
	bool isPackageOption(const TQString &package, const TQString &option);
	
public slots:
	void slotOk();

private:
	KComboBox *m_cbDocumentClass;
	KComboBox *m_cbTypefaceSize;
	KComboBox *m_cbPaperSize;
	KComboBox *m_cbEncoding;
	TQListView *m_lvClassOptions;
	TQListView *m_lvPackages;
	KLineEdit *m_leAuthor;
	KLineEdit *m_leTitle;
	KLineEdit *m_leDate;
	TQLabel    *m_lbPaperSize;
	
	TQString m_currentClass;                          
	TQString m_currentFontsize;                      
	TQString m_currentPapersize;       
	TQString m_currentEncoding;     
	bool m_currentHyperref;
	TQString m_hyperrefdriver;
	TQString m_hyperrefsetup;      
	TQStringList m_userClasslist;           
	TQStringList m_deleteDocumentClasses;       
	
	TQMap<TQString,TQStringList> m_dictDocumentClasses; 
	TQMap<TQString,bool> m_dictStandardClasses;    
	TQMap<TQString,bool> m_currentDefaultOptions;   
	TQMap<TQString,bool> m_currentSelectedOptions;   
	TQMap<TQString,bool> m_dictPackagesEditable;   
	TQMap<TQString,TQString> m_dictPackagesDefaultvalues;     
	TQMap<TQString,bool> m_dictHyperrefDriver;   
	
	KPushButton *m_btnDocumentClassAdd;
	KPushButton *m_btnDocumentClassDelete;
	KPushButton *m_btnTypefaceSizeAdd;
	KPushButton *m_btnTypefaceSizeDelete;
	KPushButton *m_btnPaperSizeAdd;
	KPushButton *m_btnPaperSizeDelete;
	KPushButton *m_btnEncodingAdd;
	KPushButton *m_btnEncodingDelete;
	
	KPushButton *m_btnClassOptionsAdd;
	KPushButton *m_btnClassOptionsEdit;
	KPushButton *m_btnClassOptionsDelete;
	KPushButton *m_btnPackagesAdd;
	KPushButton *m_btnPackagesAddOption;
	KPushButton *m_btnPackagesEdit;
	KPushButton *m_btnPackagesDelete;
	KPushButton *m_btnPackagesReset;

	// GUI
	TQWidget *setupClassOptions(TQTabWidget *tab);           
	TQWidget *setupPackages(TQTabWidget *tab);                
	TQWidget *setupProperties(TQTabWidget *tab);              
	
	// read/write config files and init data
	void readConfig();
	void readDocumentClassConfig();
	void readPackagesConfig();
	void initHyperref();
	void writeConfig();
	void writeDocumentClassConfig();
	void writePackagesConfig();                
	
	// document class tab
	void initDocumentClass(); 
	void initStandardClass(const TQString &classname,const TQString &fontsize,      
	                       const TQString &papersize,const TQString &defaultoptions,
	                       const TQString &selectedoptions);
	void initStandardOptions(const TQString &classname,TQStringList &optionlist); 	
	void setDefaultClassOptions(const TQString &defaultoptions);            
	void setSelectedClassOptions(const TQString &selectedoptions);             
	void setClassOptions(const TQStringList &list,uint start);            
	void updateClassOptions(); 
	TQString getClassOptions();  
	void fillDocumentClassCombobox();   
	void fillCombobox(KComboBox *combo, const TQString &cslist,const TQString &seltext);    
	bool addComboboxEntries(KComboBox *combo, const TQString &title,const TQString &entry);
	TQString getComboxboxList(KComboBox *combo);
		   
	bool isDefaultClassOption(const TQString &option);                   
	bool isSelectedClassOption(const TQString &option);                  
	TQString stripDefault(const TQString &s);          
	
	// packages tab
	void initPackages();
	bool readPackagesListview();        
	TQCheckListItem *insertListview(TQListView *listview,               
                                  const TQString &entry,
                                  const TQString &description);
	TQCheckListItem *insertListview(TQCheckListItem *parent,               
                                  const TQString &entry,
                                  const TQString &description);
	TQCheckListItem *insertEditableListview(TQCheckListItem *parent,               
	                                       const TQString &entry,const TQString &description,
	                                       const TQString value,const TQString defaultvalue);
	bool isListviewEntry(TQListView *listview,const TQString &entry);
	void setPackagesValue(TQListViewItem *item,const TQString &option,const TQString &val);
	TQString getPackagesValue(const TQString &value);

	bool isListviewChild(TQListView *listview,const TQString &entry, const TQString &option);
	TQString addPackageDefault(const TQString &option,const TQString &description);
	TQString stripPackageDefault(const TQString &option,const TQString &description);
	bool isHyperrefDriver(const TQString &name);
	
	// document template
	void printTemplate();
	void printPackages();
	void printHyperref();
	void printBeamerTheme();
	
	// input dialog
	bool inputDialog(TQStringList &list,int check=qd_CheckNotEmpty);

private slots:
	void slotDocumentClassAdd();
	void slotDocumentClassDelete();
	void slotDocumentClassChanged(int index);  
	void slotTypefaceSizeAdd();  
	void slotTypefaceSizeDelete();  
	void slotPaperSizeAdd();
	void slotPaperSizeDelete();
	void slotOptionDoubleClicked(TQListViewItem *listViewItem,const TQPoint &,int); 
	void slotClassOptionAdd();
	void slotClassOptionEdit();
	void slotClassOptionDelete();
	
	void slotCheckParent(TQListViewItem *listViewItem);
	void slotPackageDoubleClicked(TQListViewItem *listViewItem,const TQPoint &,int);
	void slotPackageAdd();
	void slotPackageAddOption();
	void slotPackageEdit();
	void slotPackageDelete();
	void slotPackageReset();
	
	void slotEnableButtons();
};

class QuickDocumentInputDialog : public KDialogBase  {
   Q_OBJECT
  
public: 
	QuickDocumentInputDialog(const TQStringList &list,int check=0,
	                         QuickDocument *parent=0, const char *name=0);
	~QuickDocumentInputDialog();

	void getResults(TQStringList &list);
	
private:
	QuickDocument *m_parent;
	int  m_check;
	
	TQStringList m_description;
	TQValueList<TQWidget *> m_objectlist;
		
	TQString getPackageName(const TQString &text);
	bool checkListEntries(const TQString &title, const TQString &textlist,const TQString &pattern);
	
private slots:
	void slotOk();
};

} // namespace

#endif
