/***************************************************************************
    begin                : Fri Jun 4 2004
    copyright            : (C) 2004 by Jeroen Wijnout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef CONFIGCHECKER_H
#define CONFIGCHECKER_H

#include <tqobject.h>

class KTempDir;
class TDEConfig;
class TDEProcess;
class KURL;

/**
@author Jeroen Wijnhout
*/

class ConfigTest
{
	public:
		enum Status { Success = 3, Failure = 2, Critical = 1 };

		ConfigTest();
		ConfigTest(const TQString &name, bool mustpass, const TQString &arg, const TQString &altarg = TQString());

		int status() const;

		TQString resultText() const;
		TQString name() const;

	private:
		TQString	m_name, m_arg, m_altArg;
		bool 		m_mustPass;

	public:
		static void addPrettyName(const TQString &test, const TQString &prettyName);
		static void addSuccessMessage(const TQString &test, const TQString &msg);
		static void addFailureMessage(const TQString &test, const TQString &msg);
		static void addCriticalMessage(const TQString &test, const TQString &msg);

		static TQString prettyName(const TQString &test);
		static TQString successMessage(const TQString &test);
		static TQString failureMessage(const TQString &test);
		static TQString criticalMessage(const TQString &test);

	private:
		static TQMap<TQString,TQString> s_prettyName, s_msgSuccess, s_msgFailure, s_msgCritical;
};

class Tester : public TQObject
{
	Q_OBJECT
  

public:
	Tester(TQObject *parent = 0, const char *name = 0);
	~Tester();

	TQStringList testedTools();
	TQValueList<ConfigTest> resultForTool(const TQString &);
	int statusForTool(const TQString &);

public slots:
	void runTests();
	void saveResults(const KURL &);
	void stop();

signals:
	void started();
	void percentageDone(int);
	void finished(bool);

private slots:
	void determineProgress(TDEProcess *, char *, int);
	void processTestResults (TDEProcess *);
	void processTool(TDEConfig *, const TQString &);

	void addResult(const TQString &tool, const TQValueList<ConfigTest> &tests);

private:
	TQMap<TQString,TQValueList<ConfigTest> >	m_results;
	TQString								m_resultsFile;
	KTempDir							*m_tempDir;
	TDEProcess								*m_process;
};

#endif
