/* This file is part of the KDE libraries
   Copyright (C) 1998 Kurt Granroth <granroth@kde.org>
   Copyright (C) 2000 Peter Putzer <putzer@kde.org>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KERRYLABEL_H
#define KERRYLABEL_H

#include <kurl.h>
#include <kurllabel.h>

class TQTextDrag;

class KerryLabel : public KURLLabel
{
  Q_OBJECT
  

  public:
    KerryLabel (TQWidget* parent = 0L, const char* name = 0L);

  protected:
    void mousePressEvent( TQMouseEvent* );
    void mouseReleaseEvent( TQMouseEvent* );
    void mouseMoveEvent( TQMouseEvent* );
    void doDrag();

  protected slots:
    void popupMenu( const TQPoint &_global );

  private:
    KURL::List kurllist;

    enum DragState { diNone, diPending, diDragging };

    struct _dragInfo {
      DragState       state;
      TQPoint          start;
      TQTextDrag       *dragObject;
    } dragInfo;
};

#endif // KERRYLABEL_H
