/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#ifndef __SEARCH_H__
#define __SEARCH_H__

#include <tqcheckbox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqspinbox.h>
#include <tqwhatsthis.h>
#include <tdecmodule.h>
#include <tqcombobox.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <tdelocale.h>

class KCMKerrySearch : public TDECModule
{
  Q_OBJECT
  

public:
  KCMKerrySearch(TQWidget *parent=0, const char *name=0);
  ~KCMKerrySearch();

  virtual void load();
  virtual void load( bool useDefaults );
  virtual void save();
  virtual void defaults();

protected slots:
  void changedValue();

private:
    TQSpinBox *maxResultsDisplayed;
    TQComboBox* combo_order;
    TQCheckBox* showBigTiles;
    KKeyChooser *keysWidget;
    TDEGlobalAccel *globalKeys;
};

#endif
